const char *sh_vertex_code =
"#version 330 core\n"

"layout(location = 0) in vec3 position;\n"
"layout(location = 1) in struct Coeff { \n"
"       vec3 c0;        \n"     // gets location 1, order 0 coeffs
"       vec3 c1[3];     \n"     // gets location 2, 3 and 4, order 1 coeffs
"       vec3 c2[5];     \n"     // gets location 5 up to 9, order 2 coeffs
"       vec4 c3[6];     \n"     // gets location 10 to 15, order 3 coeffs part 1
"} coeff;\n"

"uniform mat4 VP;\n"
"uniform int L;\n"      // sh order
"uniform vec3 cam_pos;\n"

"out vec3 v_color;\n"

"const float inv_pi = 0.3183099;\n"

"float SH(int l, int m, vec3 xyz)\n"
"{\n"
"       float x = xyz.x, y = xyz.y, z = xyz.z;\n"
"       float rr = x*x+y*y+z*z;\n"
"       if (l == 0)\n"
"               return sqrt(inv_pi)/2;\n"
"       else if (l == 1 && m == -1)\n"
"               return sqrt(3*inv_pi/4)*y/sqrt(rr);\n"
"       else if (l == 1 && m == 0)\n"
"               return sqrt(3*inv_pi/4)*z/sqrt(rr);\n"
"       else if (l == 1 && m == 1)\n"
"               return sqrt(3*inv_pi/4)*x/sqrt(rr);\n"
"       else if (l == 2 && m == -2)\n"
"               return sqrt(15*inv_pi/4)*x*y/rr;\n"
"       else if (l == 2 && m == -1)\n"
"               return sqrt(15*inv_pi/4)*y*z/rr;\n"
"       else if (l == 2 && m == 0)\n"
"               return sqrt(5*inv_pi/16)*(-x*x-y*y+2*z*z)/rr;\n"
"       else if (l == 2 && m == 1)\n"
"               return sqrt(15*inv_pi/4)*z*x/rr;\n"
"       else if (l == 2 && m == 2)\n"
"               return sqrt(15*inv_pi/16)*(x*x-y*y)/rr;\n"
"       else if (l == 3 && m == -3)\n"
"               return sqrt(35*inv_pi/32)*(3*x*x-y*y)*y/(rr)/sqrt(rr);\n"
"       else if (l == 3 && m == -2)\n"
"               return sqrt(105*inv_pi/4)*x*y*z/(rr)/sqrt(rr);\n"
"       else if (l == 3 && m == -1)\n"
"               return sqrt(21*inv_pi/32)*y*(4*z*z-x*x-y*y)/(rr)/sqrt(rr);\n"
"       else if (l == 3 && m == 0)\n"
"               return sqrt(7*inv_pi/16)*z*(2*z*z-3*x*x-3*y*y)/(rr)/sqrt(rr);\n"
"       else if (l == 3 && m == 1)\n"
"               return sqrt(21*inv_pi/32)*x*(4*z*z-x*x-y*y)/(rr)/sqrt(rr);\n"
"       else if (l == 3 && m == 2)\n"
"               return sqrt(105*inv_pi/16)*(x*x-y*y)*z/(rr)/sqrt(rr);\n"
"       else if (l == 3 && m == 3)\n"
"               return sqrt(35*inv_pi/32)*(x*x-3*y*y)*x/(rr)/sqrt(rr);\n"
"       else\n"
"               return 0;\n"
"}\n"

"void main()\n"
"{\n"
"	gl_Position = VP * vec4(position, 1.0);\n"

"       vec3 dir = position - cam_pos;\n"
"       v_color = coeff.c0 * SH(0, 0, dir);\n"

"       if (L >= 1) {\n"
"               v_color += coeff.c1[0] * SH(1, -1, dir)\n"
"                       + coeff.c1[1] * SH(1, 0, dir)\n"
"                       + coeff.c1[2] * SH(1, 1, dir);\n"
"       }\n"
"       if (L >= 2) {\n"
"               v_color += coeff.c2[0] * SH(2, -2, dir)\n"
"                       + coeff.c2[1] * SH(2, -1, dir)\n"
"                       + coeff.c2[2] * SH(2, 0, dir)\n"
"                       + coeff.c2[3] * SH(2, 1, dir)\n"
"                       + coeff.c2[4] * SH(2, 2, dir);\n"
"       }\n"
"       if (L >= 3) {\n"
"               v_color += coeff.c3[0].xyz * SH(3, -3, dir)\n"
"                       + vec3(coeff.c3[0].w, coeff.c3[1].xy) * SH(3, -2, dir)\n"
"                       + vec3(coeff.c3[1].zw, coeff.c3[2].x) * SH(3, -1, dir)\n"
"                       + coeff.c3[2].yzw * SH(3, 0, dir)\n"
"                       + coeff.c3[3].xyz * SH(3, 1, dir)\n"
"                       + vec3(coeff.c3[3].w, coeff.c3[4].xy) * SH(3, 2, dir)\n"
"                       + vec3(coeff.c3[4].zw, coeff.c3[5].x) * SH(3, 3, dir);\n"
"       }\n"
"}\n";
