from fastapi import FastAPI, Request
from fastapi.responses import JSONResponse, FileResponse
from fastapi.middleware.cors import CORSMiddleware


app = FastAPI()
app.add_middleware(
    CORSMiddleware,
    allow_origins=["*"],
    allow_credentials=True,
    allow_methods=["*"],
    allow_headers=["*"],
)


@app.get("/speech/{file_name}")
async def get_speech(file_name: str):
    file_path = f"./.bin/audio_dumps/{file_name}.wav"
    return FileResponse(file_path, media_type="audio/wav")


if __name__ == "__main__""":
    import uvicorn
    uvicorn.run(app, host="127.0.0.1", port=8001)