import os
# os.environ["PHONEMIZER_ESPEAK_LIBRARY"] = os.path.abspath(os.path.join(os.getcwd(), r".\eSpeak NG\libespeak-ng.dll"))
# os.environ["PHONEMIZER_ESPEAK_PATH"] = os.path.abspath(os.path.join(os.getcwd(), r".\eSpeak NG\espeak-ng.exe")) 
from fastapi import FastAPI, Request
from fastapi.responses import JSONResponse
from fastapi.middleware.cors import CORSMiddleware
from dotenv import load_dotenv
from pymongo import MongoClient
import json
from uuid import uuid4
from tts import generate_audio
import datetime
import subprocess
import sys


FILE_SERVER = None
def start_file_server():
    global FILE_SERVER
    if FILE_SERVER is None:
        FILE_SERVER = subprocess.Popen([sys.executable, "fs.py"], shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)


def stop_file_server():
    global FILE_SERVER
    if FILE_SERVER is not None:
        FILE_SERVER.kill()
        FILE_SERVER = None


start_file_server()
app = FastAPI()
# Load environment variables from .env file
load_dotenv(override=True)
DB_CLIENT = MongoClient(os.environ.get("MONGO_URI"))
DATABASE = DB_CLIENT["ECHO"]

COLLECTIONS = {
    "generations": DATABASE["generations"],
    "users": DATABASE["users"],
    "plans": DATABASE["plans"],
    "sessions": DATABASE["sessions"]
}

app.add_middleware(
    CORSMiddleware,
    allow_origins=["*"],
    allow_credentials=True,
    allow_methods=["*"],
    allow_headers=["*"]
)

AUDIO_STORE_PATH = "./audio_store"



async def generate_uuid():
    return str(uuid4())



async def verify_session(session_token: str):
    session = COLLECTIONS["sessions"].find_one({"session_token": session_token})
    if not session:
        return False
    return session


@app.post("/speech/generate")
async def generate_speech(request: Request):
    data = await request.json()
    text = data.get("text")
    auto_pause = True if data.get("auto_pause") == True else False
    print(auto_pause)
    speed = int(data.get("speed", 1))
    input_type = data.get("input_type")
    input_file_name = data.get("input_file_name", "")
    voice = data.get("voice")

    sessioin_token = request.headers.get("echo-auth")
    __user__ = await verify_session(sessioin_token)
    if not __user__:
        return JSONResponse({"error": "Unauthorized"}, status_code=401)

    file_name = await generate_uuid()
    generate_audio(text_input=text, file_name=file_name, auto_pause=auto_pause, speaking_speed=speed, voice=voice)

    COLLECTIONS["generations"].insert_one({
        "uuid": __user__["uuid"],
        "text": text,
        "input_type": input_type,
        "file_name": input_file_name,
        "created_at": int(datetime.datetime.now().timestamp()),
        "audio": f"{file_name}.wav",
        "voice": voice
    })

    return JSONResponse({"audio": "http://127.0.0.1:8001/speech/" + file_name})