import{s as fs,a as Is,n as js,o as bs}from"../chunks/scheduler.19cc4639.js";import{S as Cs,i as $s,e as i,s,c as M,h as vs,a as o,d as l,b as a,f as Tt,g as p,j as r,k as j,l as mt,m as n,n as m,t as u,o as d,p as c}from"../chunks/index.6703add8.js";import{C as Bs,H as T,E as _s}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.a6202e33.js";import{C as w}from"../chunks/CodeBlock.454e7a46.js";import{C as Zs}from"../chunks/CourseFloatingBanner.ca685b90.js";function As(hn){let J,Jt,wt,ht,b,gt,C,Ut,$,ft,v,gn=`Welcome to the practical section! Here you’ll put into practice everything you’ve learned about vision language models (VLMs) using <strong>HuggingFaceTB/SmolVLM2-2.2B-Instruct</strong>.<br/>
The exercises progress from foundational concepts to advanced techniques, helping you gain real-world, hands-on experience.`,It,B,jt,_,Un="By the end of these exercises, you will be able to:",bt,Z,fn="<li><strong>Work with VLM datasets</strong>: Explore and prepare <strong>HuggingFaceM4/ChartQA</strong>.</li> <li><strong>Optimize training</strong>: Apply <strong>quantization</strong> and <strong>PEFT</strong> for efficient fine-tuning.</li> <li><strong>Fine-tune models in practice</strong>: Train <strong>HuggingFaceTB/SmolVLM2-2.2B-Instruct</strong> using both Python APIs and CLI tools.</li> <li><strong>Adapt datasets for TRL</strong>: Prepare VLM datasets to integrate seamlessly with TRL workflows.</li> <li><strong>Move to production</strong>: Understand how to scale and manage <strong>production-ready fine-tuning workflows</strong> for VLMs.</li>",Ct,A,$t,W,In="<strong>Objective:</strong> Get familiar with the <code>SmolVLM2-2.2B-Instruct</code> model and evaluate the model using a sample from the dataset.",vt,x,Bt,h,jn="<ul><li>You need a GPU with at least 8GB VRAM for training. CPU/MPS can run formatting and dataset exploration, but training larger models will likely fail.</li> <li>First run will download several GB of model weights; ensure 15GB+ free disk and a stable connection.</li> <li>If you need access to private repos, authenticate with Hugging Face Hub via <code>login()</code>.</li></ul>",_t,H,bn=`First, install the required libraries: <code>transformers</code>, <code>datasets</code>, <code>trl</code>,<code>huggingface_hub</code>, and <code>trackio</code>.<br/>
These packages provide the tools for working with the model, datasets, and Hugging Face Hub.`,Zt,R,At,F,Wt,L,Cn="Now, import the main dependencies we’ll use:",xt,k,Ht,G,Rt,E,Ft,Q,$n="We start by selecting the device where the model will run. It can be a GPU (<code>cuda</code>), Apple Silicon (<code>mps</code>), or the CPU as a fallback.",Lt,V,kt,X,Gt,N,vn="To work with private models or to <strong>push your fine-tuned model to the Hub</strong> (as we’ll do in this exercise), you need to authenticate with your Hugging Face account.",Et,g,Bn='<p>You can create and copy your access token from the <a href="https://huggingface.co/settings/tokens" rel="nofollow">Hugging Face tokens page</a> in your profile.</p>',Qt,S,Vt,Y,Xt,q,_n=`Finally, we load the <strong>HuggingFaceTB/SmolVLM2-2.2B-Instruct</strong> model.
The <code>AutoProcessor</code> is also initialized here — it ensures that both text and images are preprocessed correctly before being passed to the model.`,Nt,z,St,P,Yt,D,Zn="In this step, we load a small subset of the <strong>ChartQA</strong> dataset — just 10% of the training and validation splits — to keep the exercises fast and manageable for learning purposes.",qt,K,An=`We then display one of the chart images using <code>matplotlib</code> to get a visual sense of the model’s input.<br/>
Additionally, we print the corresponding query and label so you can fully understand the dataset structure and the type of tasks the model will handle.`,zt,y,Wn,Pt,O,Dt,U,ut,xn="Output",wn,ee,Kt,te,Ot,le,Hn='<img src="https://huggingface.co/datasets/smol-course/images/resolve/main/model_output.png" alt="Model output"/>',el,ne,tl,se,Rn="We create a <strong>chat message list</strong> that includes a user query along with the image.",ll,ae,Fn="Using <code>processor.apply_chat_template</code>, we transform this into the exact input format the model expects.",nl,ie,sl,f,dt,Ln="Output",yn,oe,al,re,il,Me,kn=`We tokenize the chat prompt and image into tensors, then generate a response with the model.
Finally, we decode the output tokens back into text.`,ol,pe,rl,I,ct,Gn="Output",Jn,me,Ml,ue,En="The model generates a reponse, but it’s not exactly correct. It could be improved with some fine-tuning. Now that we’ve seen how to build prompts and generate responses with <strong>SmolVLM2-2.2B-Instruct</strong>, it’s time to learn how to adapt and <strong>fine-tune</strong> the model efficiently using <strong>LoRA (Low-Rank Adaptation)</strong>. This approach allows training large models with fewer resources and prepares the model for specific downstream tasks.",pl,de,ml,ce,Qn="In this exercise, we’ll apply <strong>LoRA (Low-Rank Adaptation)</strong> to fine-tune our Vision-Language Model efficiently.",ul,Te,Vn=`LoRA works by injecting <strong>trainable low-rank matrices</strong> into existing model layers, enabling <strong>large models to be fine-tuned with significantly fewer trainable parameters</strong>.<br/>
This approach reduces memory usage and speeds up training while maintaining high performance.`,dl,we,cl,ye,Xn="We’ll format the dataset into a <strong>chatbot-style structure</strong>, where each example includes:",Tl,Je,Nn="<li>A <strong>system message</strong> defining the assistant’s role</li> <li>The <strong>chart image</strong></li> <li>The <strong>user query</strong></li> <li>The <strong>expected answer</strong></li>",wl,he,Sn=`This is the format expected by the <code>SFTTrainer</code>, including the <code>images</code> and <code>messages</code> columns.<br/>
You can learn more about preparing datasets for VLM post-training in the <a href="https://huggingface.co/docs/trl/en/sft_trainer#training-vision-language-models" rel="nofollow">documentation</a>.`,yl,Jl,hl,ge,gl,Ue,Yn=`The first step is to structure the dataset for VLM training.<br/>
We’ll define a <strong>system message</strong> that instructs the model to act as a <strong>chart analysis expert</strong>, providing <strong>concise, accurate answers</strong> about chart images.`,Ul,fe,fl,Ie,qn="Now, let’s format the data using the chatbot structure. This will set up the interactions for the model.",Il,je,jl,be,bl,Ce,zn="Here we define a <code>LoraConfig</code>:",Cl,$e,Pn="<li><code>r</code> and <code>lora_alpha</code> control the rank and scaling of the adaptation matrices.</li> <li><code>target_modules</code> specifies which parts of the model to adapt.</li> <li><code>task_type</code> is set for causal language modeling.</li>",$l,ve,Dn="We then apply LoRA to the base model using <code>get_peft_model</code> and print out the trainable parameters to verify the adaptation.",vl,Be,Bl,_e,_l,Ze,Kn="We configure the <strong>SFTTrainer</strong> from <code>trl</code> with <code>SFTConfig</code>:",Zl,Ae,On="<li><code>num_train_epochs</code>, <code>batch_size</code>, and <code>gradient_accumulation_steps</code> control the training loop.</li> <li><code>gradient_checkpointing</code>, and <code>bf16</code> optimize memory and speed.</li> <li><code>learning_rate</code> manages optimization.</li> <li><code>train_dataset</code> and <code>eval_dataset</code> are aligned with your dataset.</li>",Al,We,es="This prepares the trainer to handle fine-tuning with PEFT/LoRA.",Wl,xe,xl,He,Hl,Re,ts="Now we run the training loop:",Rl,Fe,ls="<li><code>trainer.train()</code> starts fine-tuning with LoRA.</li> <li><code>trainer.save_model()</code> stores the locally trained model.</li>",Fl,Le,ns="This step ensures the model is ready for downstream tasks with minimal additional parameters.",Ll,ke,kl,Ge,ss="With the foundations of Python-based fine-tuning and LoRA in place, we can now move this workflow to a <strong>production environment</strong> using the <strong>TRL CLI</strong>. This approach lets you automate fine-tuning and create reproducible pipelines without writing full Python scripts.",Gl,Ee,El,Qe,as="In the previous exercises, we focused on using the Python API to fine-tune <strong>SmolVLM2-2.2B-Instruct</strong>, exploring dataset preparation and generating chat-style prompts.",Ql,Ve,is='In this exercise, we’ll demonstrate how to perform fine-tuning using the <strong>TRL CLI</strong>, a common workflow in production environments. The CLI allows you to run experiments and manage training without writing Python scripts. If you want a refresher, we previously introduced this tool <a href="../unit1/4#exercise-4-production-workflow-with-trl-cli">here</a>, and the same concepts and troubleshooting tips apply.',Vl,Xe,os="The TRL CLI leverages the same logic and configuration options as the Python API but presents them through a simple command-line interface. This means you can define everything—from the model and dataset to training hyperparameters and output location—in a single command.",Xl,Ne,rs="The example below shows how to fine-tune <strong>SmolVLM2-2.2B-Instruct</strong> on the <strong>trl-lib/llava-instruct-mix</strong> dataset, using LoRA for parameter-efficient fine-tuning, mixed precision for faster training, and optional push-to-Hub for sharing your model. The dataset now is different.",Nl,Se,Ms="We are using a different dataset here because it already comes formatted in the expected VLM structure, as discussed earlier.",Sl,Ye,ps="<li><code>--model_name_or_path</code> specifies the base model to fine-tune.</li> <li><code>--dataset_name</code> and <code>--dataset_config</code> define the dataset and subset.</li> <li><code>--output_dir</code> sets the local directory for saving the fine-tuned model.</li> <li><code>--per_device_train_batch_size</code> and <code>--gradient_accumulation_steps</code> control effective batch size and memory usage.</li> <li><code>--learning_rate</code>, <code>--num_train_epochs</code>, and <code>--max_length</code> define the core training hyperparameters.</li> <li><code>--bf16</code> enables mixed precision for faster and more memory-efficient training on compatible GPUs.</li> <li><code>--push_to_hub</code> and <code>--hub_model_id</code> allow automatic upload of the trained model to your Hugging Face Hub repository.</li>",Yl,qe,ms="Using the TRL CLI is functionally equivalent to writing a full Python training script, but it’s faster to configure, easier to reproduce, and ideal for production pipelines or automated training workflows.",ql,ze,zl,Pe,Pl,De,us=`In <a href="../unit1/5">Unit 1</a>, we introduced <strong>Hugging Face Jobs (HF Jobs)</strong> and demonstrated how to fine-tune a model using this managed cloud service.<br/>
HF Jobs provides a <strong>fully managed infrastructure</strong> for training models, eliminating the need to set up GPUs, manage dependencies, or configure environments locally. This is especially useful for <strong>SFT training</strong>, which can be both resource-intensive and time-consuming.`,Dl,Ke,ds=`Following the same approach, we can use HF Jobs to fine-tune our Vision-Language Model (VLM).<br/>
If needed, refer back to Unit 1 to refresh your understanding of HF Jobs and their workflow.`,Kl,Oe,cs="Here’s an example of how to launch a training job using <strong>TRL’s maintained SFT script</strong>:",Ol,et,en,tt,Ts="After launching the job, HF Jobs will handle the <strong>entire training process</strong> in the cloud. You can monitor progress, view logs, and track metrics directly from the Hugging Face Hub.",tn,lt,ws="Once the job completes:",ln,nt,ys="<li>The <strong>fine-tuned model</strong> will be available in the <code>output_dir</code> you specified.</li> <li>If <code>--push_to_hub</code> was used, the model will also be <strong>accessible from your Hugging Face account</strong>, ready for inference or further fine-tuning.</li> <li>You can <strong>resume, replicate, or scale</strong> training easily by re-running or modifying the job configuration.</li>",nn,st,Js="This workflow removes the overhead of managing local resources, allowing you to focus on <strong>model experimentation and evaluation</strong>.",sn,at,an,it,hs=`You’ve completed the unit — great work!
Now put your learning to the test by taking the <a href="https://huggingface.co/spaces/smol-course/unit_4_quiz" rel="nofollow">quiz</a>.`,on,ot,rn,rt,gs="Here are some helpful resources to deepen your understanding and continue experimenting with vision language models and TRL workflows:",Mn,Mt,Us='<li><strong><a href="https://huggingface.co/docs/trl/" rel="nofollow">TRL Documentation</a></strong> – Complete reference for using TRL, including Python API and CLI.</li> <li><strong><a href="https://huggingface.co/HuggingFaceTB/SmolVLM2-2.2B-Instruct" rel="nofollow">HuggingFaceTB/SmolVLM2-2.2B-Instruct Model Card</a></strong> – Detailed information about the model architecture, training, and usage.</li> <li><strong><a href="https://huggingface.co/datasets/HuggingFaceM4/ChartQA" rel="nofollow">HuggingFaceM4/ChartQA Dataset</a></strong> – Dataset used for training and fine-tuning VLMs.</li> <li><strong><a href="https://huggingface.co/" rel="nofollow">Hugging Face Hub</a></strong> – Platform to share your fine-tuned models and discover community models.</li> <li><strong><a href="https://discord.gg/huggingface" rel="nofollow">Hugging Face Discord Community</a></strong> – Join the community for discussions, support, and troubleshooting.</li>',pn,pt,mn,yt,un;return b=new Bs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new T({props:{title:"Hands-On Exercises: Fine-Tuning SmolVLM2-2.2B-Instruct",local:"hands-on-exercises-fine-tuning-smolvlm2-22b-instruct",headingTag:"h1"}}),$=new Zs({props:{chapter:10,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/smol-course/blob/main/notebooks/4/4.ipynb"}]}}),B=new T({props:{title:"Learning Objectives",local:"learning-objectives",headingTag:"h2"}}),A=new T({props:{title:"Exercise 1: Explore SmolVLM2-2.2B-Instruct",local:"exercise-1-explore-smolvlm2-22b-instruct",headingTag:"h3"}}),x=new T({props:{title:"Environment Setup",local:"environment-setup",headingTag:"h3"}}),R=new w({props:{code:"JTIzJTIwSW5zdGFsbCUyMHJlcXVpcmVkJTIwcGFja2FnZXMlMjAocnVuJTIwaW4lMjBDb2xhYiUyMG9yJTIweW91ciUyMGVudmlyb25tZW50KSUwQXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlMjBkYXRhc2V0cyUyMHRybCUyMGh1Z2dpbmdmYWNlX2h1YiUyMHRyYWNraW8lMjBudW0yd29yZHMlM0QlM0QwLjUuMTQ=",highlighted:`<span class="hljs-comment"># Install required packages (run in Colab or your environment)</span>
pip install transformers datasets trl huggingface_hub trackio num2words==0.5.14`,wrap:!1}}),F=new T({props:{title:"Import dependencies",local:"import-dependencies",headingTag:"h3"}}),k=new w({props:{code:"JTIzJTIwSW1wb3J0JTIwZGVwZW5kZW5jaWVzJTBBJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBvcyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvUHJvY2Vzc29yJTJDJTIwQXV0b01vZGVsRm9ySW1hZ2VUZXh0VG9UZXh0JTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5pbWFnZV91dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2U=",highlighted:`<span class="hljs-comment"># Import dependencies</span>

<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText, BitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers.image_utils <span class="hljs-keyword">import</span> load_image`,wrap:!1}}),G=new T({props:{title:"Load the model and processor",local:"load-the-model-and-processor",headingTag:"h3"}}),E=new T({props:{title:"1. Select the device",local:"1-select-the-device",headingTag:"h4"}}),V=new w({props:{code:"ZGV2aWNlJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMmN1ZGElMjIlMEElMjAlMjAlMjAlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMEElMjAlMjAlMjAlMjBlbHNlJTIwJTIybXBzJTIyJTIwaWYlMjB0b3JjaC5iYWNrZW5kcy5tcHMuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyJTBBKQ==",highlighted:`device = (
    <span class="hljs-string">&quot;cuda&quot;</span>
    <span class="hljs-keyword">if</span> torch.cuda.is_available()
    <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;mps&quot;</span> <span class="hljs-keyword">if</span> torch.backends.mps.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
)`,wrap:!1}}),X=new T({props:{title:"2. Authenticate with Hugging Face",local:"2-authenticate-with-hugging-face",headingTag:"h4"}}),S=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
login()`,wrap:!1}}),Y=new T({props:{title:"3. Load the model and processor",local:"3-load-the-model-and-processor",headingTag:"h4"}}),z=new w({props:{code:"bW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sVkxNMi0yLjJCLUluc3RydWN0JTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlMkMlMEElMjAlMjAlMjAlMjBkdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKS50byhkZXZpY2UpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSk=",highlighted:`model_name = <span class="hljs-string">&quot;HuggingFaceTB/SmolVLM2-2.2B-Instruct&quot;</span>
model = AutoModelForImageTextToText.from_pretrained(
    model_name,
    dtype=torch.bfloat16,
).to(device)

processor = AutoProcessor.from_pretrained(model_name)`,wrap:!1}}),P=new T({props:{title:"Explore the dataset",local:"explore-the-dataset",headingTag:"h3"}}),O=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXRyYWluX2RhdGFzZXQlMkMlMjBldmFsX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIySHVnZ2luZ0ZhY2VNNCUyRkNoYXJ0UUElMjIlMkMlMjBzcGxpdCUzRCU1QiUyMnRyYWluJTVCJTNBMTAlMjUlNUQlMjIlMkMlMjAlMjJ2YWwlNUIlM0ExMCUyNSU1RCUyMiU1RCklMEFleGFtcGxlJTIwJTNEJTIwdHJhaW5fZGF0YXNldCU1QjElNUQlMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoZXhhbXBsZSU1QiUyMmltYWdlJTIyJTVEKSUwQSUwQXByaW50KGV4YW1wbGUlNUIlMjJxdWVyeSUyMiU1RCklMEFwcmludChleGFtcGxlJTVCJTIybGFiZWwlMjIlNUQlNUIwJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

train_dataset, eval_dataset = load_dataset(<span class="hljs-string">&quot;HuggingFaceM4/ChartQA&quot;</span>, split=[<span class="hljs-string">&quot;train[:10%]&quot;</span>, <span class="hljs-string">&quot;val[:10%]&quot;</span>])
example = train_dataset[<span class="hljs-number">1</span>]
image = load_image(example[<span class="hljs-string">&quot;image&quot;</span>])

<span class="hljs-built_in">print</span>(example[<span class="hljs-string">&quot;query&quot;</span>])
<span class="hljs-built_in">print</span>(example[<span class="hljs-string">&quot;label&quot;</span>][<span class="hljs-number">0</span>])`,wrap:!1}}),ee=new w({props:{code:"SG93JTIwbWFueSUyMHZhbHVlcyUyMGFyZSUyMGJlbG93JTIwNDAlMjBpbiUyMFVuZmF2b3JhYmxlJTIwZ3JhcGglM0YlMEE2",highlighted:`How many values are below 40 in Unfavorable graph?
6`,wrap:!1}}),te=new w({props:{code:"cGx0Lmltc2hvdyhpbWFnZSklMEFwbHQuYXhpcyglMjJvZmYlMjIpJTBBcGx0LnRpdGxlKCUyMlNhbXBsZSUyMENoYXJ0JTIwSW1hZ2UlMjIpJTBBcGx0LnNob3coKQ==",highlighted:`plt.imshow(image)
plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
plt.title(<span class="hljs-string">&quot;Sample Chart Image&quot;</span>)
plt.show()`,wrap:!1}}),ne=new T({props:{title:"Build a chat-style prompt",local:"build-a-chat-style-prompt",headingTag:"h3"}}),ie=new w({props:{code:"JTIzJTIwRGVmaW5lJTIwYSUyMGNoYXQtc3R5bGUlMjBwcm9tcHQlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJpbWFnZSUyMiUyQyUyMCUyMmltYWdlJTIyJTNBJTIwaW1hZ2UlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjBleGFtcGxlJTVCJTIycXVlcnklMjIlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlN0QlMEElNUQlMEElMEElMjMlMjBBcHBseSUyMHRoZSUyMGNoYXQlMjB0ZW1wbGF0ZSUwQWNoYXRfcHJvbXB0JTIwJTNEJTIwcHJvY2Vzc29yLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTVDJTBBKSUwQXByaW50KGNoYXRfcHJvbXB0KQ==",highlighted:`<span class="hljs-comment"># Define a chat-style prompt</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: [
        {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;image&quot;</span>: image},
        {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: example[<span class="hljs-string">&quot;query&quot;</span>]},
    ]}
]

<span class="hljs-comment"># Apply the chat template</span>
chat_prompt = processor.apply_chat_template(
      messages, add_generation_prompt=<span class="hljs-literal">True</span>\\
)
<span class="hljs-built_in">print</span>(chat_prompt)`,wrap:!1}}),oe=new w({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VVc2VyJTNBJTNDaW1hZ2UlM0VIb3clMjBtYW55JTIwdmFsdWVzJTIwYXJlJTIwYmVsb3clMjA0MCUyMGluJTIwVW5mYXZvcmFibGUlMjBncmFwaCUzRiUzQ2VuZF9vZl91dHRlcmFuY2UlM0UlMEFBc3Npc3RhbnQlM0E=",highlighted:`&lt;|im_start|&gt;User:&lt;image&gt;How many values are below 40 in Unfavorable graph?&lt;end_of_utterance&gt;
Assistant:`,wrap:!1}}),re=new T({props:{title:"Run inference",local:"run-inference",headingTag:"h3"}}),pe=new w({props:{code:"JTIzJTIwVG9rZW5pemUlMjBpbnB1dCUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0QlNUJpbWFnZSU1RCUyQyUyMHRleHQlM0RjaGF0X3Byb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSklMEElMEElMjMlMjBHZW5lcmF0ZSUyMG1vZGVsJTIwb3V0cHV0JTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCklMEElMEElMjMlMjBUcmltJTIwdGhlJTIwZ2VuZXJhdGVkJTIwaWRzJTIwdG8lMjByZW1vdmUlMjB0aGUlMjBpbnB1dCUyMGlkcyUwQXRyaW1tZWRfZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMCU1Qm91dF9pZHMlNUJsZW4oaW5faWRzKSUyMCUzQSU1RCUyMGZvciUyMGluX2lkcyUyQyUyMG91dF9pZHMlMjBpbiUyMHppcChpbnB1dHMuaW5wdXRfaWRzJTJDJTIwb3V0cHV0KSU1RCUwQSUwQSUyMyUyMERlY29kZSUyMHRoZSUyMG91dHB1dCUyMHRleHQlMEFvdXRwdXRfdGV4dCUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoJTBBJTIwJTIwJTIwJTIwdHJpbW1lZF9nZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UlMEEpJTBBcHJpbnQob3V0cHV0X3RleHQlNUIwJTVEKQ==",highlighted:`<span class="hljs-comment"># Tokenize input</span>
inputs = processor(images=[image], text=chat_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-comment"># Generate model output</span>
<span class="hljs-keyword">with</span> torch.no_grad():
    output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">20</span>)

<span class="hljs-comment"># Trim the generated ids to remove the input ids</span>
trimmed_generated_ids = [out_ids[<span class="hljs-built_in">len</span>(in_ids) :] <span class="hljs-keyword">for</span> in_ids, out_ids <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(inputs.input_ids, output)]

<span class="hljs-comment"># Decode the output text</span>
output_text = processor.batch_decode(
    trimmed_generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>
)
<span class="hljs-built_in">print</span>(output_text[<span class="hljs-number">0</span>])`,wrap:!1}}),me=new w({props:{code:"JTIwMy4=",highlighted:" 3.",wrap:!1}}),de=new T({props:{title:"Exercise 2: Fine-Tune the Model Using LoRA",local:"exercise-2-fine-tune-the-model-using-lora",headingTag:"h2"}}),we=new w({props:{code:"c3lzdGVtX21lc3NhZ2UlMjAlM0QlMjAlMjIlMjIlMjJZb3UlMjBhcmUlMjBhJTIwVmlzaW9uJTIwTGFuZ3VhZ2UlMjBNb2RlbCUyMHNwZWNpYWxpemVkJTIwaW4lMjBpbnRlcnByZXRpbmclMjB2aXN1YWwlMjBkYXRhJTIwZnJvbSUyMGNoYXJ0JTIwaW1hZ2VzLiUwQVlvdXIlMjB0YXNrJTIwaXMlMjB0byUyMGFuYWx5emUlMjB0aGUlMjBwcm92aWRlZCUyMGNoYXJ0JTIwaW1hZ2UlMjBhbmQlMjByZXNwb25kJTIwdG8lMjBxdWVyaWVzJTIwd2l0aCUyMGNvbmNpc2UlMjBhbnN3ZXJzJTJDJTIwdXN1YWxseSUyMGElMjBzaW5nbGUlMjB3b3JkJTJDJTIwbnVtYmVyJTJDJTIwb3IlMjBzaG9ydCUyMHBocmFzZS4lMEFUaGUlMjBjaGFydHMlMjBpbmNsdWRlJTIwYSUyMHZhcmlldHklMjBvZiUyMHR5cGVzJTIwKGUuZy4lMkMlMjBsaW5lJTIwY2hhcnRzJTJDJTIwYmFyJTIwY2hhcnRzKSUyMGFuZCUyMGNvbnRhaW4lMjBjb2xvcnMlMkMlMjBsYWJlbHMlMkMlMjBhbmQlMjB0ZXh0LiUwQUZvY3VzJTIwb24lMjBkZWxpdmVyaW5nJTIwYWNjdXJhdGUlMkMlMjBzdWNjaW5jdCUyMGFuc3dlcnMlMjBiYXNlZCUyMG9uJTIwdGhlJTIwdmlzdWFsJTIwaW5mb3JtYXRpb24uJTIwQXZvaWQlMjBhZGRpdGlvbmFsJTIwZXhwbGFuYXRpb24lMjB1bmxlc3MlMjBhYnNvbHV0ZWx5JTIwbmVjZXNzYXJ5LiUyMiUyMiUyMg==",highlighted:`system_message = <span class="hljs-string">&quot;&quot;&quot;You are a Vision Language Model specialized in interpreting visual data from chart images.
Your task is to analyze the provided chart image and respond to queries with concise answers, usually a single word, number, or short phrase.
The charts include a variety of types (e.g., line charts, bar charts) and contain colors, labels, and text.
Focus on delivering accurate, succinct answers based on the visual information. Avoid additional explanation unless absolutely necessary.&quot;&quot;&quot;</span>`,wrap:!1}}),ge=new T({props:{title:"Format the Dataset",local:"format-the-dataset",headingTag:"h3"}}),fe=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_data</span>(<span class="hljs-params">sample</span>):
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;images&quot;</span>: [sample[<span class="hljs-string">&quot;image&quot;</span>]],
        <span class="hljs-string">&quot;messages&quot;</span>: [
            {
                <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
                <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: system_message}],
            },
            {
                <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
                <span class="hljs-string">&quot;content&quot;</span>: [
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>,
                        <span class="hljs-string">&quot;image&quot;</span>: sample[<span class="hljs-string">&quot;image&quot;</span>],
                    },
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                        <span class="hljs-string">&quot;text&quot;</span>: sample[<span class="hljs-string">&quot;query&quot;</span>],
                    },
                ],
            },
            {
                <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
                <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: sample[<span class="hljs-string">&quot;label&quot;</span>][<span class="hljs-number">0</span>]}],
            },
        ],
    }`,wrap:!1}}),je=new w({props:{code:"dHJhaW5fZGF0YXNldCUyMCUzRCUyMCU1QmZvcm1hdF9kYXRhKHNhbXBsZSklMjBmb3IlMjBzYW1wbGUlMjBpbiUyMHRyYWluX2RhdGFzZXQlNUQlMEFldmFsX2RhdGFzZXQlMjAlM0QlMjAlNUJmb3JtYXRfZGF0YShzYW1wbGUpJTIwZm9yJTIwc2FtcGxlJTIwaW4lMjBldmFsX2RhdGFzZXQlNUQ=",highlighted:`train_dataset = [format_data(sample) <span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> train_dataset]
eval_dataset = [format_data(sample) <span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> eval_dataset]`,wrap:!1}}),be=new T({props:{title:"Configure LoRA",local:"configure-lora",headingTag:"h3"}}),Be=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEElMjMlMjBDb25maWd1cmUlMjBMb1JBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMkMlMEElMjAlMjAlMjAlMjByJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTBBKSUwQSUwQSUyMyUyMEFwcGx5JTIwUEVGVCUyMG1vZGVsJTIwYWRhcHRhdGlvbiUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMHBlZnRfY29uZmlnKSUwQSUwQSUyMyUyMFByaW50JTIwdHJhaW5hYmxlJTIwcGFyYW1ldGVycyUwQXBlZnRfbW9kZWwucHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMoKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

<span class="hljs-comment"># Configure LoRA</span>
peft_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    r=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>],
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

<span class="hljs-comment"># Apply PEFT model adaptation</span>
peft_model = get_peft_model(model, peft_config)

<span class="hljs-comment"># Print trainable parameters</span>
peft_model.print_trainable_parameters()`,wrap:!1}}),_e=new T({props:{title:"Set up the Trainer",local:"set-up-the-trainer",headingTag:"h3"}}),xe=new w({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEElMjMlMjBDb25maWd1cmUlMjB0cmFpbmluZyUyMGFyZ3VtZW50cyUyMHVzaW5nJTIwU0ZUQ29uZmlnJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFNGVENvbmZpZyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIyc21vbC1jb3Vyc2Utc21vbHZsbTItMi4yYi1pbnN0cnVjdC10cmwtc2Z0LUNoYXJ0UUElMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNEMSUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTQlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjBvcHRpbSUzRCUyMmFkYW13X3RvcmNoX2Z1c2VkJTIyJTJDJTBBJTIwJTIwJTIwJTIwYmYxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBwdXNoX3RvX2h1YiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlMjJ0cmFja2lvJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X2xlbmd0aCUzRE5vbmUlMkMlMEEpJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMFRyYWluZXIlMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGV2YWxfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEcGVmdF9jb25maWclMkMlMEEpJTBBJTBBJTIzJTIwQWxpZ24lMjB0aGUlMjBTRlRUcmFpbmVyJTIwcGFyYW1zJTIwd2l0aCUyMHlvdXIlMjBjaG9zZW4lMjBkYXRhc2V0Lg==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

<span class="hljs-comment"># Configure training arguments using SFTConfig</span>
training_args = SFTConfig(
    output_dir=<span class="hljs-string">&quot;smol-course-smolvlm2-2.2b-instruct-trl-sft-ChartQA&quot;</span>,
    num_train_epochs=<span class="hljs-number">1</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,
    learning_rate=<span class="hljs-number">1e-4</span>,
    logging_steps=<span class="hljs-number">25</span>,
    save_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    save_steps=<span class="hljs-number">25</span>,
    optim=<span class="hljs-string">&quot;adamw_torch_fused&quot;</span>,
    bf16=<span class="hljs-literal">True</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    report_to=<span class="hljs-string">&quot;trackio&quot;</span>,
    max_length=<span class="hljs-literal">None</span>,
)

<span class="hljs-comment"># Initialize the Trainer</span>
trainer = SFTTrainer(
    model=model,
    args=training_args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
    peft_config=peft_config,
)

<span class="hljs-comment"># Align the SFTTrainer params with your chosen dataset.</span>`,wrap:!1}}),He=new T({props:{title:"Train and Save the Model",local:"train-and-save-the-model",headingTag:"h3"}}),ke=new w({props:{code:"JTIzJTIwVHJhaW4lMjB0aGUlMjBtb2RlbCUwQXRyYWluZXIudHJhaW4oKSUwQSUwQSUyMyUyMFNhdmUlMjB0aGUlMjBtb2RlbCUwQXRyYWluZXIuc2F2ZV9tb2RlbCh0cmFpbmluZ19hcmdzLm91dHB1dF9kaXIp",highlighted:`<span class="hljs-comment"># Train the model</span>
trainer.train()

<span class="hljs-comment"># Save the model</span>
trainer.save_model(training_args.output_dir)`,wrap:!1}}),Ee=new T({props:{title:"Exercise 3: Production Workflow with TRL CLI",local:"exercise-3-production-workflow-with-trl-cli",headingTag:"h2"}}),ze=new w({props:{code:"dHJsJTIwc2Z0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBIdWdnaW5nRmFjZVRCJTJGU21vbFZMTTItMi4yQi1JbnN0cnVjdCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9uYW1lJTIwdHJsLWxpYiUyRmxsYXZhLWluc3RydWN0LW1peCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMC4lMkZzbW9sdmxuLWluc3RydWN0LXNmdC1jbGklMjAlNUMlMEElMjAlMjAlMjAlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMDE2JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sZWFybmluZ19yYXRlJTIwMmUtNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbnVtX3RyYWluX2Vwb2NocyUyMDMlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF9sZW5ndGglMjAtMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbG9nZ2luZ19zdGVwcyUyMDUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXNhdmVfc3RlcHMlMjAxMDAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXdhcm11cF9zdGVwcyUyMDUwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1iZjE2JTIwVHJ1ZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcHVzaF90b19odWIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWh1Yl9tb2RlbF9pZCUyMHlvdXItdXNlcm5hbWUlMkZzbW9sdmxtMi0yLjJiLWluc3RydWN0LXNmdC1jbGk=",highlighted:`trl sft \\
    --model_name_or_path HuggingFaceTB/SmolVLM2-2.2B-Instruct \\
    --dataset_name trl-lib/llava-instruct-mix \\
    --output_dir ./smolvln-instruct-sft-cli \\
    --per_device_train_batch_size 1 \\
    --gradient_accumulation_steps 16 \\
    --learning_rate 2e-4 \\
    --num_train_epochs 3 \\
    --max_length -1 \\
    --logging_steps 5 \\
    --save_steps 100 \\
    --warmup_steps 50 \\
    --bf16 True \\
    --push_to_hub \\
    --hub_model_id your-username/smolvlm2-2.2b-instruct-sft-cli`,wrap:!1}}),Pe=new T({props:{title:"Exercise 4: Training with Hugging Face Jobs",local:"exercise-4-training-with-hugging-face-jobs",headingTag:"h2"}}),et=new w({props:{code:"JTIzJTIwVXNlJTIwVFJMJ3MlMjBtYWludGFpbmVkJTIwU0ZUJTIwc2NyaXB0JTIwZGlyZWN0bHklMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZmxhdm9yJTIwYTEwZy1sYXJnZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGltZW91dCUyMDJoJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1zZWNyZXRzJTIwSEZfVE9LRU4lMjAlNUMlMEElMjAlMjAlMjAlMjAtLXdpdGglMjBudW0yd29yZHMlM0QlM0QwLjUuMTQlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZodWdnaW5nZmFjZSUyRnRybCUyRm1haW4lMkZ0cmwlMkZzY3JpcHRzJTJGc2Z0LnB5JTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBIdWdnaW5nRmFjZVRCJTJGU21vbFZMTTItMi4yQi1JbnN0cnVjdCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9uYW1lJTIwdHJsLWxpYiUyRmxsYXZhLWluc3RydWN0LW1peCU1QyUwQSUyMCUyMCUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUyMDVlLTUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF9sZW5ndGglMjAtMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWF4X3N0ZXBzJTIwMTAwMCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMHNtb2x2bG0yLTIuMmItaW5zdHJ1Y3Qtc2Z0LWpvYnMlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXB1c2hfdG9faHViJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1odWJfbW9kZWxfaWQlMjB5b3VyLXVzZXJuYW1lJTJGc21vbHZsbTItMi4yYi1pbnN0cnVjdC1zZnQtam9icyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVwb3J0X3RvJTIwdHJhY2tpbw==",highlighted:`<span class="hljs-comment"># Use TRL&#x27;s maintained SFT script directly</span>
hf <span class="hljs-built_in">jobs</span> uv run \\
    --flavor a10g-large \\
    --<span class="hljs-built_in">timeout</span> 2h \\
    --secrets HF_TOKEN \\
    --with num2words==0.5.14 \\
    <span class="hljs-string">&quot;https://raw.githubusercontent.com/huggingface/trl/main/trl/scripts/sft.py&quot;</span> \\
    --model_name_or_path HuggingFaceTB/SmolVLM2-2.2B-Instruct \\
    --dataset_name trl-lib/llava-instruct-mix\\
    --learning_rate 5e-5 \\
    --per_device_train_batch_size 4 \\
    --max_length -1 \\
    --max_steps 1000 \\
    --output_dir smolvlm2-2.2b-instruct-sft-jobs \\
    --push_to_hub \\
    --hub_model_id your-username/smolvlm2-2.2b-instruct-sft-jobs \\
    --report_to trackio`,wrap:!1}}),at=new T({props:{title:"Test your knowledge",local:"test-your-knowledge",headingTag:"h2"}}),ot=new T({props:{title:"Resources for Further Learning",local:"resources-for-further-learning",headingTag:"h2"}}),pt=new _s({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/en/unit3/4.md"}}),{c(){J=i("meta"),Jt=s(),wt=i("p"),ht=s(),M(b.$$.fragment),gt=s(),M(C.$$.fragment),Ut=s(),M($.$$.fragment),ft=s(),v=i("p"),v.innerHTML=gn,It=s(),M(B.$$.fragment),jt=s(),_=i("p"),_.textContent=Un,bt=s(),Z=i("ul"),Z.innerHTML=fn,Ct=s(),M(A.$$.fragment),$t=s(),W=i("p"),W.innerHTML=In,vt=s(),M(x.$$.fragment),Bt=s(),h=i("blockquote"),h.innerHTML=jn,_t=s(),H=i("p"),H.innerHTML=bn,Zt=s(),M(R.$$.fragment),At=s(),M(F.$$.fragment),Wt=s(),L=i("p"),L.textContent=Cn,xt=s(),M(k.$$.fragment),Ht=s(),M(G.$$.fragment),Rt=s(),M(E.$$.fragment),Ft=s(),Q=i("p"),Q.innerHTML=$n,Lt=s(),M(V.$$.fragment),kt=s(),M(X.$$.fragment),Gt=s(),N=i("p"),N.innerHTML=vn,Et=s(),g=i("blockquote"),g.innerHTML=Bn,Qt=s(),M(S.$$.fragment),Vt=s(),M(Y.$$.fragment),Xt=s(),q=i("p"),q.innerHTML=_n,Nt=s(),M(z.$$.fragment),St=s(),M(P.$$.fragment),Yt=s(),D=i("p"),D.innerHTML=Zn,qt=s(),K=i("p"),K.innerHTML=An,zt=s(),y=i("iframe"),Pt=s(),M(O.$$.fragment),Dt=s(),U=i("details"),ut=i("summary"),ut.textContent=xn,wn=s(),M(ee.$$.fragment),Kt=s(),M(te.$$.fragment),Ot=s(),le=i("p"),le.innerHTML=Hn,el=s(),M(ne.$$.fragment),tl=s(),se=i("p"),se.innerHTML=Rn,ll=s(),ae=i("p"),ae.innerHTML=Fn,nl=s(),M(ie.$$.fragment),sl=s(),f=i("details"),dt=i("summary"),dt.textContent=Ln,yn=s(),M(oe.$$.fragment),al=s(),M(re.$$.fragment),il=s(),Me=i("p"),Me.textContent=kn,ol=s(),M(pe.$$.fragment),rl=s(),I=i("details"),ct=i("summary"),ct.textContent=Gn,Jn=s(),M(me.$$.fragment),Ml=s(),ue=i("p"),ue.innerHTML=En,pl=s(),M(de.$$.fragment),ml=s(),ce=i("p"),ce.innerHTML=Qn,ul=s(),Te=i("p"),Te.innerHTML=Vn,dl=s(),M(we.$$.fragment),cl=s(),ye=i("p"),ye.innerHTML=Xn,Tl=s(),Je=i("ul"),Je.innerHTML=Nn,wl=s(),he=i("p"),he.innerHTML=Sn,yl=s(),Jl=i("hr"),hl=s(),M(ge.$$.fragment),gl=s(),Ue=i("p"),Ue.innerHTML=Yn,Ul=s(),M(fe.$$.fragment),fl=s(),Ie=i("p"),Ie.textContent=qn,Il=s(),M(je.$$.fragment),jl=s(),M(be.$$.fragment),bl=s(),Ce=i("p"),Ce.innerHTML=zn,Cl=s(),$e=i("ul"),$e.innerHTML=Pn,$l=s(),ve=i("p"),ve.innerHTML=Dn,vl=s(),M(Be.$$.fragment),Bl=s(),M(_e.$$.fragment),_l=s(),Ze=i("p"),Ze.innerHTML=Kn,Zl=s(),Ae=i("ul"),Ae.innerHTML=On,Al=s(),We=i("p"),We.textContent=es,Wl=s(),M(xe.$$.fragment),xl=s(),M(He.$$.fragment),Hl=s(),Re=i("p"),Re.textContent=ts,Rl=s(),Fe=i("ol"),Fe.innerHTML=ls,Fl=s(),Le=i("p"),Le.textContent=ns,Ll=s(),M(ke.$$.fragment),kl=s(),Ge=i("p"),Ge.innerHTML=ss,Gl=s(),M(Ee.$$.fragment),El=s(),Qe=i("p"),Qe.innerHTML=as,Ql=s(),Ve=i("p"),Ve.innerHTML=is,Vl=s(),Xe=i("p"),Xe.textContent=os,Xl=s(),Ne=i("p"),Ne.innerHTML=rs,Nl=s(),Se=i("p"),Se.textContent=Ms,Sl=s(),Ye=i("ul"),Ye.innerHTML=ps,Yl=s(),qe=i("p"),qe.textContent=ms,ql=s(),M(ze.$$.fragment),zl=s(),M(Pe.$$.fragment),Pl=s(),De=i("p"),De.innerHTML=us,Dl=s(),Ke=i("p"),Ke.innerHTML=ds,Kl=s(),Oe=i("p"),Oe.innerHTML=cs,Ol=s(),M(et.$$.fragment),en=s(),tt=i("p"),tt.innerHTML=Ts,tn=s(),lt=i("p"),lt.textContent=ws,ln=s(),nt=i("ul"),nt.innerHTML=ys,nn=s(),st=i("p"),st.innerHTML=Js,sn=s(),M(at.$$.fragment),an=s(),it=i("p"),it.innerHTML=hs,on=s(),M(ot.$$.fragment),rn=s(),rt=i("p"),rt.textContent=gs,Mn=s(),Mt=i("ul"),Mt.innerHTML=Us,pn=s(),M(pt.$$.fragment),mn=s(),yt=i("p"),this.h()},l(e){const t=vs("svelte-u9bgzb",document.head);J=o(t,"META",{name:!0,content:!0}),t.forEach(l),Jt=a(e),wt=o(e,"P",{}),Tt(wt).forEach(l),ht=a(e),p(b.$$.fragment,e),gt=a(e),p(C.$$.fragment,e),Ut=a(e),p($.$$.fragment,e),ft=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1a5nqhq"&&(v.innerHTML=gn),It=a(e),p(B.$$.fragment,e),jt=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1l3bdg3"&&(_.textContent=Un),bt=a(e),Z=o(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-od3cka"&&(Z.innerHTML=fn),Ct=a(e),p(A.$$.fragment,e),$t=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-bijktq"&&(W.innerHTML=In),vt=a(e),p(x.$$.fragment,e),Bt=a(e),h=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-2reic0"&&(h.innerHTML=jn),_t=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-qqkglq"&&(H.innerHTML=bn),Zt=a(e),p(R.$$.fragment,e),At=a(e),p(F.$$.fragment,e),Wt=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-zl3b16"&&(L.textContent=Cn),xt=a(e),p(k.$$.fragment,e),Ht=a(e),p(G.$$.fragment,e),Rt=a(e),p(E.$$.fragment,e),Ft=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-7eoqdg"&&(Q.innerHTML=$n),Lt=a(e),p(V.$$.fragment,e),kt=a(e),p(X.$$.fragment,e),Gt=a(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-tskkwt"&&(N.innerHTML=vn),Et=a(e),g=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-9q1nng"&&(g.innerHTML=Bn),Qt=a(e),p(S.$$.fragment,e),Vt=a(e),p(Y.$$.fragment,e),Xt=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1b4foh6"&&(q.innerHTML=_n),Nt=a(e),p(z.$$.fragment,e),St=a(e),p(P.$$.fragment,e),Yt=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-er66b7"&&(D.innerHTML=Zn),qt=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-yemwqz"&&(K.innerHTML=An),zt=a(e),y=o(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Tt(y).forEach(l),Pt=a(e),p(O.$$.fragment,e),Dt=a(e),U=o(e,"DETAILS",{});var dn=Tt(U);ut=o(dn,"SUMMARY",{"data-svelte-h":!0}),r(ut)!=="svelte-nfzy3j"&&(ut.textContent=xn),wn=a(dn),p(ee.$$.fragment,dn),dn.forEach(l),Kt=a(e),p(te.$$.fragment,e),Ot=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-12h2lj2"&&(le.innerHTML=Hn),el=a(e),p(ne.$$.fragment,e),tl=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-jpokh4"&&(se.innerHTML=Rn),ll=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-17uxmem"&&(ae.innerHTML=Fn),nl=a(e),p(ie.$$.fragment,e),sl=a(e),f=o(e,"DETAILS",{});var cn=Tt(f);dt=o(cn,"SUMMARY",{"data-svelte-h":!0}),r(dt)!=="svelte-nfzy3j"&&(dt.textContent=Ln),yn=a(cn),p(oe.$$.fragment,cn),cn.forEach(l),al=a(e),p(re.$$.fragment,e),il=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1qdjv1p"&&(Me.textContent=kn),ol=a(e),p(pe.$$.fragment,e),rl=a(e),I=o(e,"DETAILS",{});var Tn=Tt(I);ct=o(Tn,"SUMMARY",{"data-svelte-h":!0}),r(ct)!=="svelte-nfzy3j"&&(ct.textContent=Gn),Jn=a(Tn),p(me.$$.fragment,Tn),Tn.forEach(l),Ml=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-luk36"&&(ue.innerHTML=En),pl=a(e),p(de.$$.fragment,e),ml=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-5z70n4"&&(ce.innerHTML=Qn),ul=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-dkenf7"&&(Te.innerHTML=Vn),dl=a(e),p(we.$$.fragment,e),cl=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-ejreso"&&(ye.innerHTML=Xn),Tl=a(e),Je=o(e,"UL",{"data-svelte-h":!0}),r(Je)!=="svelte-wqfgg1"&&(Je.innerHTML=Nn),wl=a(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1w4jpzn"&&(he.innerHTML=Sn),yl=a(e),Jl=o(e,"HR",{}),hl=a(e),p(ge.$$.fragment,e),gl=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-41v40k"&&(Ue.innerHTML=Yn),Ul=a(e),p(fe.$$.fragment,e),fl=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-ximgze"&&(Ie.textContent=qn),Il=a(e),p(je.$$.fragment,e),jl=a(e),p(be.$$.fragment,e),bl=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1h7mh3h"&&(Ce.innerHTML=zn),Cl=a(e),$e=o(e,"UL",{"data-svelte-h":!0}),r($e)!=="svelte-2ch3wm"&&($e.innerHTML=Pn),$l=a(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1n114ah"&&(ve.innerHTML=Dn),vl=a(e),p(Be.$$.fragment,e),Bl=a(e),p(_e.$$.fragment,e),_l=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-8dwavv"&&(Ze.innerHTML=Kn),Zl=a(e),Ae=o(e,"UL",{"data-svelte-h":!0}),r(Ae)!=="svelte-1kixzkm"&&(Ae.innerHTML=On),Al=a(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-170mf7l"&&(We.textContent=es),Wl=a(e),p(xe.$$.fragment,e),xl=a(e),p(He.$$.fragment,e),Hl=a(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-kxzbug"&&(Re.textContent=ts),Rl=a(e),Fe=o(e,"OL",{"data-svelte-h":!0}),r(Fe)!=="svelte-pbze45"&&(Fe.innerHTML=ls),Fl=a(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-tqjfkj"&&(Le.textContent=ns),Ll=a(e),p(ke.$$.fragment,e),kl=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1eg4wzk"&&(Ge.innerHTML=ss),Gl=a(e),p(Ee.$$.fragment,e),El=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-idq95d"&&(Qe.innerHTML=as),Ql=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1b32icm"&&(Ve.innerHTML=is),Vl=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-97m84n"&&(Xe.textContent=os),Xl=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1smtf1g"&&(Ne.innerHTML=rs),Nl=a(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-hiqun9"&&(Se.textContent=Ms),Sl=a(e),Ye=o(e,"UL",{"data-svelte-h":!0}),r(Ye)!=="svelte-1ajz8o2"&&(Ye.innerHTML=ps),Yl=a(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-16jnk0c"&&(qe.textContent=ms),ql=a(e),p(ze.$$.fragment,e),zl=a(e),p(Pe.$$.fragment,e),Pl=a(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-38jf8e"&&(De.innerHTML=us),Dl=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-nf31ng"&&(Ke.innerHTML=ds),Kl=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-14o8e9l"&&(Oe.innerHTML=cs),Ol=a(e),p(et.$$.fragment,e),en=a(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1lncu3d"&&(tt.innerHTML=Ts),tn=a(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-aqr5u9"&&(lt.textContent=ws),ln=a(e),nt=o(e,"UL",{"data-svelte-h":!0}),r(nt)!=="svelte-16pbkoa"&&(nt.innerHTML=ys),nn=a(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1r3yd65"&&(st.innerHTML=Js),sn=a(e),p(at.$$.fragment,e),an=a(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-42sriz"&&(it.innerHTML=hs),on=a(e),p(ot.$$.fragment,e),rn=a(e),rt=o(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-nf8xdu"&&(rt.textContent=gs),Mn=a(e),Mt=o(e,"UL",{"data-svelte-h":!0}),r(Mt)!=="svelte-b7ldte"&&(Mt.innerHTML=Us),pn=a(e),p(pt.$$.fragment,e),mn=a(e),yt=o(e,"P",{}),Tt(yt).forEach(l),this.h()},h(){j(J,"name","hf:doc:metadata"),j(J,"content",Ws),j(h,"class","warning"),j(g,"class","tip"),Is(y.src,Wn="https://huggingface.co/datasets/HuggingFaceM4/ChartQA/embed/viewer/default/train")||j(y,"src",Wn),j(y,"frameborder","0"),j(y,"width","100%"),j(y,"height","560px")},m(e,t){mt(document.head,J),n(e,Jt,t),n(e,wt,t),n(e,ht,t),m(b,e,t),n(e,gt,t),m(C,e,t),n(e,Ut,t),m($,e,t),n(e,ft,t),n(e,v,t),n(e,It,t),m(B,e,t),n(e,jt,t),n(e,_,t),n(e,bt,t),n(e,Z,t),n(e,Ct,t),m(A,e,t),n(e,$t,t),n(e,W,t),n(e,vt,t),m(x,e,t),n(e,Bt,t),n(e,h,t),n(e,_t,t),n(e,H,t),n(e,Zt,t),m(R,e,t),n(e,At,t),m(F,e,t),n(e,Wt,t),n(e,L,t),n(e,xt,t),m(k,e,t),n(e,Ht,t),m(G,e,t),n(e,Rt,t),m(E,e,t),n(e,Ft,t),n(e,Q,t),n(e,Lt,t),m(V,e,t),n(e,kt,t),m(X,e,t),n(e,Gt,t),n(e,N,t),n(e,Et,t),n(e,g,t),n(e,Qt,t),m(S,e,t),n(e,Vt,t),m(Y,e,t),n(e,Xt,t),n(e,q,t),n(e,Nt,t),m(z,e,t),n(e,St,t),m(P,e,t),n(e,Yt,t),n(e,D,t),n(e,qt,t),n(e,K,t),n(e,zt,t),n(e,y,t),n(e,Pt,t),m(O,e,t),n(e,Dt,t),n(e,U,t),mt(U,ut),mt(U,wn),m(ee,U,null),n(e,Kt,t),m(te,e,t),n(e,Ot,t),n(e,le,t),n(e,el,t),m(ne,e,t),n(e,tl,t),n(e,se,t),n(e,ll,t),n(e,ae,t),n(e,nl,t),m(ie,e,t),n(e,sl,t),n(e,f,t),mt(f,dt),mt(f,yn),m(oe,f,null),n(e,al,t),m(re,e,t),n(e,il,t),n(e,Me,t),n(e,ol,t),m(pe,e,t),n(e,rl,t),n(e,I,t),mt(I,ct),mt(I,Jn),m(me,I,null),n(e,Ml,t),n(e,ue,t),n(e,pl,t),m(de,e,t),n(e,ml,t),n(e,ce,t),n(e,ul,t),n(e,Te,t),n(e,dl,t),m(we,e,t),n(e,cl,t),n(e,ye,t),n(e,Tl,t),n(e,Je,t),n(e,wl,t),n(e,he,t),n(e,yl,t),n(e,Jl,t),n(e,hl,t),m(ge,e,t),n(e,gl,t),n(e,Ue,t),n(e,Ul,t),m(fe,e,t),n(e,fl,t),n(e,Ie,t),n(e,Il,t),m(je,e,t),n(e,jl,t),m(be,e,t),n(e,bl,t),n(e,Ce,t),n(e,Cl,t),n(e,$e,t),n(e,$l,t),n(e,ve,t),n(e,vl,t),m(Be,e,t),n(e,Bl,t),m(_e,e,t),n(e,_l,t),n(e,Ze,t),n(e,Zl,t),n(e,Ae,t),n(e,Al,t),n(e,We,t),n(e,Wl,t),m(xe,e,t),n(e,xl,t),m(He,e,t),n(e,Hl,t),n(e,Re,t),n(e,Rl,t),n(e,Fe,t),n(e,Fl,t),n(e,Le,t),n(e,Ll,t),m(ke,e,t),n(e,kl,t),n(e,Ge,t),n(e,Gl,t),m(Ee,e,t),n(e,El,t),n(e,Qe,t),n(e,Ql,t),n(e,Ve,t),n(e,Vl,t),n(e,Xe,t),n(e,Xl,t),n(e,Ne,t),n(e,Nl,t),n(e,Se,t),n(e,Sl,t),n(e,Ye,t),n(e,Yl,t),n(e,qe,t),n(e,ql,t),m(ze,e,t),n(e,zl,t),m(Pe,e,t),n(e,Pl,t),n(e,De,t),n(e,Dl,t),n(e,Ke,t),n(e,Kl,t),n(e,Oe,t),n(e,Ol,t),m(et,e,t),n(e,en,t),n(e,tt,t),n(e,tn,t),n(e,lt,t),n(e,ln,t),n(e,nt,t),n(e,nn,t),n(e,st,t),n(e,sn,t),m(at,e,t),n(e,an,t),n(e,it,t),n(e,on,t),m(ot,e,t),n(e,rn,t),n(e,rt,t),n(e,Mn,t),n(e,Mt,t),n(e,pn,t),m(pt,e,t),n(e,mn,t),n(e,yt,t),un=!0},p:js,i(e){un||(u(b.$$.fragment,e),u(C.$$.fragment,e),u($.$$.fragment,e),u(B.$$.fragment,e),u(A.$$.fragment,e),u(x.$$.fragment,e),u(R.$$.fragment,e),u(F.$$.fragment,e),u(k.$$.fragment,e),u(G.$$.fragment,e),u(E.$$.fragment,e),u(V.$$.fragment,e),u(X.$$.fragment,e),u(S.$$.fragment,e),u(Y.$$.fragment,e),u(z.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(de.$$.fragment,e),u(we.$$.fragment,e),u(ge.$$.fragment,e),u(fe.$$.fragment,e),u(je.$$.fragment,e),u(be.$$.fragment,e),u(Be.$$.fragment,e),u(_e.$$.fragment,e),u(xe.$$.fragment,e),u(He.$$.fragment,e),u(ke.$$.fragment,e),u(Ee.$$.fragment,e),u(ze.$$.fragment,e),u(Pe.$$.fragment,e),u(et.$$.fragment,e),u(at.$$.fragment,e),u(ot.$$.fragment,e),u(pt.$$.fragment,e),un=!0)},o(e){d(b.$$.fragment,e),d(C.$$.fragment,e),d($.$$.fragment,e),d(B.$$.fragment,e),d(A.$$.fragment,e),d(x.$$.fragment,e),d(R.$$.fragment,e),d(F.$$.fragment,e),d(k.$$.fragment,e),d(G.$$.fragment,e),d(E.$$.fragment,e),d(V.$$.fragment,e),d(X.$$.fragment,e),d(S.$$.fragment,e),d(Y.$$.fragment,e),d(z.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(pe.$$.fragment,e),d(me.$$.fragment,e),d(de.$$.fragment,e),d(we.$$.fragment,e),d(ge.$$.fragment,e),d(fe.$$.fragment,e),d(je.$$.fragment,e),d(be.$$.fragment,e),d(Be.$$.fragment,e),d(_e.$$.fragment,e),d(xe.$$.fragment,e),d(He.$$.fragment,e),d(ke.$$.fragment,e),d(Ee.$$.fragment,e),d(ze.$$.fragment,e),d(Pe.$$.fragment,e),d(et.$$.fragment,e),d(at.$$.fragment,e),d(ot.$$.fragment,e),d(pt.$$.fragment,e),un=!1},d(e){e&&(l(Jt),l(wt),l(ht),l(gt),l(Ut),l(ft),l(v),l(It),l(jt),l(_),l(bt),l(Z),l(Ct),l($t),l(W),l(vt),l(Bt),l(h),l(_t),l(H),l(Zt),l(At),l(Wt),l(L),l(xt),l(Ht),l(Rt),l(Ft),l(Q),l(Lt),l(kt),l(Gt),l(N),l(Et),l(g),l(Qt),l(Vt),l(Xt),l(q),l(Nt),l(St),l(Yt),l(D),l(qt),l(K),l(zt),l(y),l(Pt),l(Dt),l(U),l(Kt),l(Ot),l(le),l(el),l(tl),l(se),l(ll),l(ae),l(nl),l(sl),l(f),l(al),l(il),l(Me),l(ol),l(rl),l(I),l(Ml),l(ue),l(pl),l(ml),l(ce),l(ul),l(Te),l(dl),l(cl),l(ye),l(Tl),l(Je),l(wl),l(he),l(yl),l(Jl),l(hl),l(gl),l(Ue),l(Ul),l(fl),l(Ie),l(Il),l(jl),l(bl),l(Ce),l(Cl),l($e),l($l),l(ve),l(vl),l(Bl),l(_l),l(Ze),l(Zl),l(Ae),l(Al),l(We),l(Wl),l(xl),l(Hl),l(Re),l(Rl),l(Fe),l(Fl),l(Le),l(Ll),l(kl),l(Ge),l(Gl),l(El),l(Qe),l(Ql),l(Ve),l(Vl),l(Xe),l(Xl),l(Ne),l(Nl),l(Se),l(Sl),l(Ye),l(Yl),l(qe),l(ql),l(zl),l(Pl),l(De),l(Dl),l(Ke),l(Kl),l(Oe),l(Ol),l(en),l(tt),l(tn),l(lt),l(ln),l(nt),l(nn),l(st),l(sn),l(an),l(it),l(on),l(rn),l(rt),l(Mn),l(Mt),l(pn),l(mn),l(yt)),l(J),c(b,e),c(C,e),c($,e),c(B,e),c(A,e),c(x,e),c(R,e),c(F,e),c(k,e),c(G,e),c(E,e),c(V,e),c(X,e),c(S,e),c(Y,e),c(z,e),c(P,e),c(O,e),c(ee),c(te,e),c(ne,e),c(ie,e),c(oe),c(re,e),c(pe,e),c(me),c(de,e),c(we,e),c(ge,e),c(fe,e),c(je,e),c(be,e),c(Be,e),c(_e,e),c(xe,e),c(He,e),c(ke,e),c(Ee,e),c(ze,e),c(Pe,e),c(et,e),c(at,e),c(ot,e),c(pt,e)}}}const Ws='{"title":"Hands-On Exercises: Fine-Tuning SmolVLM2-2.2B-Instruct","local":"hands-on-exercises-fine-tuning-smolvlm2-22b-instruct","sections":[{"title":"Learning Objectives","local":"learning-objectives","sections":[{"title":"Exercise 1: Explore SmolVLM2-2.2B-Instruct","local":"exercise-1-explore-smolvlm2-22b-instruct","sections":[],"depth":3},{"title":"Environment Setup","local":"environment-setup","sections":[],"depth":3},{"title":"Import dependencies","local":"import-dependencies","sections":[],"depth":3},{"title":"Load the model and processor","local":"load-the-model-and-processor","sections":[{"title":"1. Select the device","local":"1-select-the-device","sections":[],"depth":4},{"title":"2. Authenticate with Hugging Face","local":"2-authenticate-with-hugging-face","sections":[],"depth":4},{"title":"3. Load the model and processor","local":"3-load-the-model-and-processor","sections":[],"depth":4}],"depth":3},{"title":"Explore the dataset","local":"explore-the-dataset","sections":[],"depth":3},{"title":"Build a chat-style prompt","local":"build-a-chat-style-prompt","sections":[],"depth":3},{"title":"Run inference","local":"run-inference","sections":[],"depth":3}],"depth":2},{"title":"Exercise 2: Fine-Tune the Model Using LoRA","local":"exercise-2-fine-tune-the-model-using-lora","sections":[{"title":"Format the Dataset","local":"format-the-dataset","sections":[],"depth":3},{"title":"Configure LoRA","local":"configure-lora","sections":[],"depth":3},{"title":"Set up the Trainer","local":"set-up-the-trainer","sections":[],"depth":3},{"title":"Train and Save the Model","local":"train-and-save-the-model","sections":[],"depth":3}],"depth":2},{"title":"Exercise 3: Production Workflow with TRL CLI","local":"exercise-3-production-workflow-with-trl-cli","sections":[],"depth":2},{"title":"Exercise 4: Training with Hugging Face Jobs","local":"exercise-4-training-with-hugging-face-jobs","sections":[],"depth":2},{"title":"Test your knowledge","local":"test-your-knowledge","sections":[],"depth":2},{"title":"Resources for Further Learning","local":"resources-for-further-learning","sections":[],"depth":2}],"depth":1}';function xs(hn){return bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gs extends Cs{constructor(J){super(),$s(this,J,xs,As,fs,{})}}export{Gs as component};
