import{s as pt,n as mt,o as dt}from"../chunks/scheduler.19cc4639.js";import{S as Mt,i as ft,e as i,s as n,c as p,h as ht,a as o,d as l,b as s,f as rt,g as m,j as r,k as Ve,l as ct,m as a,n as d,t as M,o as f,p as h}from"../chunks/index.6703add8.js";import{C as ut,H as c,E as yt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.a6202e33.js";import{C as te}from"../chunks/CodeBlock.454e7a46.js";function gt(Xe){let u,le,O,ae,g,ne,w,se,T,xe="Parameter-Efficient Fine-Tuning (PEFT) lets you adapt large models by training a small number of additional parameters while keeping the base model frozen. The most widely used PEFT method is LoRA (Low-Rank Adaptation), which injects trainable low-rank updates into linear layers. This often reduces trainable parameters by ~90% while preserving performance.",ie,b,oe,J,qe="<li>You have limited compute or memory budget</li> <li>You need to quickly adapt a base model to multiple tasks/domains</li> <li>You want fast iteration and small artifacts (adapter weights are usually a few MB)</li>",re,j,pe,U,He="LoRA has become the most widely adopted PEFT method. It works by adding small rank decomposition matrices to the attention weights, typically reducing trainable parameters by about 90%.",me,$,Se='LoRA (Low-Rank Adaptation) is a parameter-efficient fine-tuning technique that freezes the pre-trained model weights and injects trainable rank decomposition matrices into the model’s layers. Instead of training all model parameters during fine-tuning, LoRA decomposes the weight updates into smaller matrices through low-rank decomposition, significantly reducing the number of trainable parameters while maintaining model performance. For example, when applied to GPT-3 175B, LoRA reduced trainable parameters by 10,000x and GPU memory requirements by 3x compared to full fine-tuning. You can read more about LoRA in the <a href="https://huggingface.co/papers/2106.09685" rel="nofollow">LoRA paper</a>.',de,Z,Ye="LoRA works by adding pairs of rank decomposition matrices to transformer layers, typically focusing on attention weights. During inference, these adapter weights can be merged with the base model, resulting in no additional latency overhead. LoRA is particularly useful for adapting large language models to specific tasks or domains while keeping resource requirements manageable.",Me,R,fe,v,Pe="Adapters can be loaded onto a pretrained model with load_adapter(), which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the set_adapter() function. To return the base model, you could use unload() to unload all of the LoRA modules. This makes it easy to switch between different task-specific weights.",he,k,ce,C,ze='<img src="https://huggingface.co/datasets/smol-course/images/resolve/main/lora_adapter.png" alt="lora_load_adapter"/>',ue,B,ye,F,Ne="After training with LoRA, you might want to merge the adapter weights back into the base model for easier deployment. This creates a single model with the combined weights, eliminating the need to load adapters separately during inference.",ge,E,De="The merging process requires attention to memory management and precision. Since you’ll need to load both the base model and adapter weights simultaneously, ensure sufficient GPU/CPU memory is available. Using <code>device_map=&quot;auto&quot;</code> in <code>transformers</code> will help with automatic memory management. Maintain consistent precision (e.g., float16) throughout the process, matching the precision used during training and saving the merged model in the same format for deployment. Before deploying, always validate the merged model by comparing its outputs and performance metrics with the adapter-based version.",we,_,Ke="Adapters are also be convenient for switching between different tasks or domains. You can load the base model and adapter weights separately. This allows for quick switching between different task-specific weights.",Te,y,Oe="<p>When implementing PEFT methods, start with small rank values (4-8) for LoRA and monitor training loss. Use validation sets to prevent overfitting and compare results with full fine-tuning baselines when possible. The effectiveness of different methods can vary by task, so experimentation is key.</p>",be,A,Je,I,et='<a href="https://huggingface.co/papers/2406.01775" rel="nofollow">OLoRA</a> utilizes QR decomposition to initialize the LoRA adapters. OLoRA translates the base weights of the model by a factor of their QR decompositions, i.e., it mutates the weights before performing any training on them. This approach significantly improves stability, accelerates convergence speed, and ultimately achieves superior performance.',je,L,Ue,W,tt="PEFT methods can be combined with TRL (Transformers Reinforcement Learning) for efficient fine-tuning. This integration is particularly useful for RLHF (Reinforcement Learning from Human Feedback) as it reduces memory requirements.",$e,G,Ze,Q,Re,V,lt="After training a LoRA adapter, you can merge the adapter weights back into the base model. Here’s how to do it:",ve,X,ke,x,at="If you encounter size discrepancies in the saved model, ensure you’re also saving the tokenizer:",Ce,q,Be,H,Fe,S,nt="The TRL <code>SFTTrainer</code> integrates natively with PEFT. Define a <code>LoraConfig</code>, pass it to the trainer, and train only the adapter weights.",Ee,Y,_e,P,st="After training, you can either:",Ae,z,it="<li>Load adapters at inference time alongside the base model, or</li> <li>Merge adapters into the base model for simplified deployment.</li>",Ie,N,Le,D,ot='<li><a href="https://huggingface.co/papers/2106.09685" rel="nofollow">LoRA: Low-Rank Adaptation of Large Language Models</a></li> <li><a href="https://huggingface.co/docs/peft" rel="nofollow">PEFT Documentation</a></li> <li><a href="https://huggingface.co/blog/peft" rel="nofollow">Hugging Face blog post on PEFT</a></li>',We,K,Ge,ee,Qe;return g=new ut({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new c({props:{title:"LoRA and PEFT: Efficient Fine-Tuning",local:"lora-and-peft-efficient-fine-tuning",headingTag:"h1"}}),b=new c({props:{title:"When to use PEFT",local:"when-to-use-peft",headingTag:"h2"}}),j=new c({props:{title:"Understanding LoRA",local:"understanding-lora",headingTag:"h2"}}),R=new c({props:{title:"Loading LoRA Adapters",local:"loading-lora-adapters",headingTag:"h2"}}),k=new te({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMiUzQ2Jhc2VfbW9kZWxfbmFtZSUzRSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyJTNDcGVmdF9hZGFwdGVyX2lkJTNFJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;&lt;base_model_name&gt;&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;&lt;peft_adapter_id&gt;&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)`,wrap:!1}}),B=new c({props:{title:"Merging LoRA Adapters",local:"merging-lora-adapters",headingTag:"h2"}}),A=new c({props:{title:"OLoRA",local:"olora",headingTag:"h2"}}),L=new c({props:{title:"Using TRL with PEFT",local:"using-trl-with-peft",headingTag:"h2"}}),G=new te({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEElMjMlMjBMb2FkJTIwbW9kZWwlMjB3aXRoJTIwUEVGVCUyMGNvbmZpZyUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJ5b3VyLW1vZGVsLW5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCU1QiUyMnRyYWluJTIyJTVEJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclM0Rsb3JhX2NvbmZpZyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

<span class="hljs-comment"># Load model with PEFT config</span>
lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

trainer = SFTTrainer(
    model=<span class="hljs-string">&quot;your-model-name&quot;</span>,
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>]
    peft_config=lora_config
)`,wrap:!1}}),Q=new c({props:{title:"Basic Merging Implementation",local:"basic-merging-implementation",headingTag:"h2"}}),X=new te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMFBlZnRNb2RlbCUwQSUwQSUyMyUyMDEuJTIwTG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmFzZV9tb2RlbF9uYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTBBKSUwQSUwQSUyMyUyMDIuJTIwTG9hZCUyMHRoZSUyMFBFRlQlMjBtb2RlbCUyMHdpdGglMjBhZGFwdGVyJTBBcGVmdF9tb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwYmFzZV9tb2RlbCUyQyUwQSUyMCUyMCUyMCUyMCUyMnBhdGglMkZ0byUyRmFkYXB0ZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBkdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQSUwQSUyMyUyMDMuJTIwTWVyZ2UlMjBhZGFwdGVyJTIwd2VpZ2h0cyUyMHdpdGglMjBiYXNlJTIwbW9kZWwlMEF0cnklM0ElMEElMjAlMjAlMjAlMjBtZXJnZWRfbW9kZWwlMjAlM0QlMjBwZWZ0X21vZGVsLm1lcmdlX2FuZF91bmxvYWQoKSUwQWV4Y2VwdCUyMFJ1bnRpbWVFcnJvciUyMGFzJTIwZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJNZXJnaW5nJTIwZmFpbGVkJTNBJTIwJTdCZSU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjMlMjBJbXBsZW1lbnQlMjBmYWxsYmFjayUyMHN0cmF0ZWd5JTIwb3IlMjBtZW1vcnklMjBvcHRpbWl6YXRpb24lMEElMEElMjMlMjA0LiUyMFNhdmUlMjB0aGUlMjBtZXJnZWQlMjBtb2RlbCUwQW1lcmdlZF9tb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIycGF0aCUyRnRvJTJGc2F2ZSUyRm1lcmdlZF9tb2RlbCUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

<span class="hljs-comment"># 1. Load the base model</span>
base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;base_model_name&quot;</span>,
    dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)

<span class="hljs-comment"># 2. Load the PEFT model with adapter</span>
peft_model = PeftModel.from_pretrained(
    base_model,
    <span class="hljs-string">&quot;path/to/adapter&quot;</span>,
    dtype=torch.bfloat16
)

<span class="hljs-comment"># 3. Merge adapter weights with base model</span>
<span class="hljs-keyword">try</span>:
    merged_model = peft_model.merge_and_unload()
<span class="hljs-keyword">except</span> RuntimeError <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Merging failed: <span class="hljs-subst">{e}</span>&quot;</span>)
    <span class="hljs-comment"># Implement fallback strategy or memory optimization</span>

<span class="hljs-comment"># 4. Save the merged model</span>
merged_model.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)`,wrap:!1}}),q=new te({props:{code:"JTIzJTIwU2F2ZSUyMGJvdGglMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJhc2VfbW9kZWxfbmFtZSUyMiklMEFtZXJnZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMnBhdGglMkZ0byUyRnNhdmUlMkZtZXJnZWRfbW9kZWwlMjIpJTBBdG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZzYXZlJTJGbWVyZ2VkX21vZGVsJTIyKQ==",highlighted:`<span class="hljs-comment"># Save both model and tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;base_model_name&quot;</span>)
merged_model.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)
tokenizer.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)`,wrap:!1}}),H=new c({props:{title:"Quick start with TRL + LoRA",local:"quick-start-with-trl--lora",headingTag:"h2"}}),Y=new te({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMkMlMjBTRlRDb25maWclMEElMEElMjMlMjAxKSUyMENvbmZpZ3VyZSUyMExvUkElMEFwZWZ0X2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoJTBBJTIwJTIwJTIwJTIwciUzRDglMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMkMlMEEpJTBBJTBBJTIzJTIwMiklMjBDcmVhdGUlMjB0cmFpbmVyJTIwKGV4YW1wbGUpJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RTRlRDb25maWcob3V0cHV0X2RpciUzRCUyMmxvcmEtYWRhcHRlciUyMiUyQyUyMG51bV90cmFpbl9lcG9jaHMlM0QxJTJDJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEMiUyQyUyMHBhY2tpbmclM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRHBlZnRfY29uZmlnJTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, SFTConfig

<span class="hljs-comment"># 1) Configure LoRA</span>
peft_config = LoraConfig(
    r=<span class="hljs-number">8</span>,
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

<span class="hljs-comment"># 2) Create trainer (example)</span>
trainer = SFTTrainer(
    model=model,
    args=SFTConfig(output_dir=<span class="hljs-string">&quot;lora-adapter&quot;</span>, num_train_epochs=<span class="hljs-number">1</span>, per_device_train_batch_size=<span class="hljs-number">2</span>, packing=<span class="hljs-literal">True</span>),
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
    peft_config=peft_config,
)
trainer.train()`,wrap:!1}}),N=new c({props:{title:"Resources",local:"resources",headingTag:"h1"}}),K=new yt({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/en/unit1/3a.md"}}),{c(){u=i("meta"),le=n(),O=i("p"),ae=n(),p(g.$$.fragment),ne=n(),p(w.$$.fragment),se=n(),T=i("p"),T.textContent=xe,ie=n(),p(b.$$.fragment),oe=n(),J=i("ul"),J.innerHTML=qe,re=n(),p(j.$$.fragment),pe=n(),U=i("p"),U.textContent=He,me=n(),$=i("p"),$.innerHTML=Se,de=n(),Z=i("p"),Z.textContent=Ye,Me=n(),p(R.$$.fragment),fe=n(),v=i("p"),v.textContent=Pe,he=n(),p(k.$$.fragment),ce=n(),C=i("p"),C.innerHTML=ze,ue=n(),p(B.$$.fragment),ye=n(),F=i("p"),F.textContent=Ne,ge=n(),E=i("p"),E.innerHTML=De,we=n(),_=i("p"),_.textContent=Ke,Te=n(),y=i("blockquote"),y.innerHTML=Oe,be=n(),p(A.$$.fragment),Je=n(),I=i("p"),I.innerHTML=et,je=n(),p(L.$$.fragment),Ue=n(),W=i("p"),W.textContent=tt,$e=n(),p(G.$$.fragment),Ze=n(),p(Q.$$.fragment),Re=n(),V=i("p"),V.textContent=lt,ve=n(),p(X.$$.fragment),ke=n(),x=i("p"),x.textContent=at,Ce=n(),p(q.$$.fragment),Be=n(),p(H.$$.fragment),Fe=n(),S=i("p"),S.innerHTML=nt,Ee=n(),p(Y.$$.fragment),_e=n(),P=i("p"),P.textContent=st,Ae=n(),z=i("ul"),z.innerHTML=it,Ie=n(),p(N.$$.fragment),Le=n(),D=i("ul"),D.innerHTML=ot,We=n(),p(K.$$.fragment),Ge=n(),ee=i("p"),this.h()},l(e){const t=ht("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(l),le=s(e),O=o(e,"P",{}),rt(O).forEach(l),ae=s(e),m(g.$$.fragment,e),ne=s(e),m(w.$$.fragment,e),se=s(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-dj8rbr"&&(T.textContent=xe),ie=s(e),m(b.$$.fragment,e),oe=s(e),J=o(e,"UL",{"data-svelte-h":!0}),r(J)!=="svelte-1mvsu7l"&&(J.innerHTML=qe),re=s(e),m(j.$$.fragment,e),pe=s(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-jvnjlq"&&(U.textContent=He),me=s(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1i71tti"&&($.innerHTML=Se),de=s(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1ore9lv"&&(Z.textContent=Ye),Me=s(e),m(R.$$.fragment,e),fe=s(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-ykjqgo"&&(v.textContent=Pe),he=s(e),m(k.$$.fragment,e),ce=s(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-vth2ay"&&(C.innerHTML=ze),ue=s(e),m(B.$$.fragment,e),ye=s(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-159k8bc"&&(F.textContent=Ne),ge=s(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-8mb6ny"&&(E.innerHTML=De),we=s(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-q31ewq"&&(_.textContent=Ke),Te=s(e),y=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(y)!=="svelte-1lcqkpy"&&(y.innerHTML=Oe),be=s(e),m(A.$$.fragment,e),Je=s(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1iny7jf"&&(I.innerHTML=et),je=s(e),m(L.$$.fragment,e),Ue=s(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-6e2mqf"&&(W.textContent=tt),$e=s(e),m(G.$$.fragment,e),Ze=s(e),m(Q.$$.fragment,e),Re=s(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1h2v14z"&&(V.textContent=lt),ve=s(e),m(X.$$.fragment,e),ke=s(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-j2a68t"&&(x.textContent=at),Ce=s(e),m(q.$$.fragment,e),Be=s(e),m(H.$$.fragment,e),Fe=s(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1o3osh"&&(S.innerHTML=nt),Ee=s(e),m(Y.$$.fragment,e),_e=s(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-lzynm4"&&(P.textContent=st),Ae=s(e),z=o(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-9cs1te"&&(z.innerHTML=it),Ie=s(e),m(N.$$.fragment,e),Le=s(e),D=o(e,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-1pr7vnp"&&(D.innerHTML=ot),We=s(e),m(K.$$.fragment,e),Ge=s(e),ee=o(e,"P",{}),rt(ee).forEach(l),this.h()},h(){Ve(u,"name","hf:doc:metadata"),Ve(u,"content",wt),Ve(y,"class","tip")},m(e,t){ct(document.head,u),a(e,le,t),a(e,O,t),a(e,ae,t),d(g,e,t),a(e,ne,t),d(w,e,t),a(e,se,t),a(e,T,t),a(e,ie,t),d(b,e,t),a(e,oe,t),a(e,J,t),a(e,re,t),d(j,e,t),a(e,pe,t),a(e,U,t),a(e,me,t),a(e,$,t),a(e,de,t),a(e,Z,t),a(e,Me,t),d(R,e,t),a(e,fe,t),a(e,v,t),a(e,he,t),d(k,e,t),a(e,ce,t),a(e,C,t),a(e,ue,t),d(B,e,t),a(e,ye,t),a(e,F,t),a(e,ge,t),a(e,E,t),a(e,we,t),a(e,_,t),a(e,Te,t),a(e,y,t),a(e,be,t),d(A,e,t),a(e,Je,t),a(e,I,t),a(e,je,t),d(L,e,t),a(e,Ue,t),a(e,W,t),a(e,$e,t),d(G,e,t),a(e,Ze,t),d(Q,e,t),a(e,Re,t),a(e,V,t),a(e,ve,t),d(X,e,t),a(e,ke,t),a(e,x,t),a(e,Ce,t),d(q,e,t),a(e,Be,t),d(H,e,t),a(e,Fe,t),a(e,S,t),a(e,Ee,t),d(Y,e,t),a(e,_e,t),a(e,P,t),a(e,Ae,t),a(e,z,t),a(e,Ie,t),d(N,e,t),a(e,Le,t),a(e,D,t),a(e,We,t),d(K,e,t),a(e,Ge,t),a(e,ee,t),Qe=!0},p:mt,i(e){Qe||(M(g.$$.fragment,e),M(w.$$.fragment,e),M(b.$$.fragment,e),M(j.$$.fragment,e),M(R.$$.fragment,e),M(k.$$.fragment,e),M(B.$$.fragment,e),M(A.$$.fragment,e),M(L.$$.fragment,e),M(G.$$.fragment,e),M(Q.$$.fragment,e),M(X.$$.fragment,e),M(q.$$.fragment,e),M(H.$$.fragment,e),M(Y.$$.fragment,e),M(N.$$.fragment,e),M(K.$$.fragment,e),Qe=!0)},o(e){f(g.$$.fragment,e),f(w.$$.fragment,e),f(b.$$.fragment,e),f(j.$$.fragment,e),f(R.$$.fragment,e),f(k.$$.fragment,e),f(B.$$.fragment,e),f(A.$$.fragment,e),f(L.$$.fragment,e),f(G.$$.fragment,e),f(Q.$$.fragment,e),f(X.$$.fragment,e),f(q.$$.fragment,e),f(H.$$.fragment,e),f(Y.$$.fragment,e),f(N.$$.fragment,e),f(K.$$.fragment,e),Qe=!1},d(e){e&&(l(le),l(O),l(ae),l(ne),l(se),l(T),l(ie),l(oe),l(J),l(re),l(pe),l(U),l(me),l($),l(de),l(Z),l(Me),l(fe),l(v),l(he),l(ce),l(C),l(ue),l(ye),l(F),l(ge),l(E),l(we),l(_),l(Te),l(y),l(be),l(Je),l(I),l(je),l(Ue),l(W),l($e),l(Ze),l(Re),l(V),l(ve),l(ke),l(x),l(Ce),l(Be),l(Fe),l(S),l(Ee),l(_e),l(P),l(Ae),l(z),l(Ie),l(Le),l(D),l(We),l(Ge),l(ee)),l(u),h(g,e),h(w,e),h(b,e),h(j,e),h(R,e),h(k,e),h(B,e),h(A,e),h(L,e),h(G,e),h(Q,e),h(X,e),h(q,e),h(H,e),h(Y,e),h(N,e),h(K,e)}}}const wt='{"title":"LoRA and PEFT: Efficient Fine-Tuning","local":"lora-and-peft-efficient-fine-tuning","sections":[{"title":"When to use PEFT","local":"when-to-use-peft","sections":[],"depth":2},{"title":"Understanding LoRA","local":"understanding-lora","sections":[],"depth":2},{"title":"Loading LoRA Adapters","local":"loading-lora-adapters","sections":[],"depth":2},{"title":"Merging LoRA Adapters","local":"merging-lora-adapters","sections":[],"depth":2},{"title":"OLoRA","local":"olora","sections":[],"depth":2},{"title":"Using TRL with PEFT","local":"using-trl-with-peft","sections":[],"depth":2},{"title":"Basic Merging Implementation","local":"basic-merging-implementation","sections":[],"depth":2},{"title":"Quick start with TRL + LoRA","local":"quick-start-with-trl--lora","sections":[],"depth":2}],"depth":1}';function Tt(Xe){return dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $t extends Mt{constructor(u){super(),ft(this,u,Tt,gt,pt,{})}}export{$t as component};
