import{s as GU,n as vU,o as YU}from"../chunks/scheduler.f38f3a0e.js";import{S as _U,i as WU,e as M,s as T,c as i,h as HU,a as s,d as J,b as e,f as NU,j as a,g as n,k as BU,m as LU,n as t,o as p,t as y,p as g,q as z}from"../chunks/index.a03143fc.js";import{C as qU}from"../chunks/CopyLLMTxtMenu.17993fb8.js";import{C as m}from"../chunks/CodeBlock.f339c579.js";import{C as ZU}from"../chunks/CourseFloatingBanner.9d00122a.js";import{H as o,E as AU}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.0bf997b4.js";function XU(gU){let V,ml,gl,ol,c,Vl,R,cl,O,Rl,u,zU='<a href="../1_instruction_tuning/README.md">インストラクションチューニングの章</a> では、教師あり微調整によるモデルの微調整について学びました。このセクションでは、SFTのためのインストラクションデータセットの生成方法を探ります。基本的なプロンプトを使用してインストラクションチューニングデータセットを作成する方法や、論文から得られたより洗練された技術を使用する方法を探ります。インストラクションチューニングデータセットは、SelfInstructやMagpieのような方法を使用して、インコンテキスト学習のためのシードデータを使用して作成できます。さらに、EvolInstructを通じたインストラクションの進化についても探ります。最後に、distilabelパイプラインを使用してインストラクションチューニングのためのデータセットを生成する方法を探ります。',Ol,F,ul,Q,mU="合成データは一見複雑に見えますが、モデルから知識を抽出するための効果的なプロンプトを作成することに簡略化できます。つまり、特定のタスクのためのデータを生成する方法と考えることができます。課題は、データが多様で代表的であることを保証しながら、効果的にプロンプトを作成することです。幸いなことに、多くの論文がこの問題を探求しており、このコースではいくつかの有用なものを探ります。まずは、手動でプロンプトを作成して合成データを生成する方法を探ります。",Fl,r,Ql,E,oU='基本的な例から始めましょう。<a href="https://huggingface.co/HuggingFaceTB/SmolLM2-1.7B-Instruct" rel="nofollow">HuggingFaceTB/SmolLM2-1.7B-Instruct</a>モデルを<code>distilabel</code>ライブラリの<code>transformers</code>統合を使用してロードします。<code>TextGeneration</code>クラスを使用して合成<code>プロンプト</code>を生成し、それを使用して<code>completion</code>を生成します。',rl,C,VU="次に、<code>distilabel</code>ライブラリを使用してモデルをロードします。",El,f,Cl,I,cU=`!!! note
Distilabelは<code>llm</code>をメモリにロードするため、ノートブックで作業する場合は、メモリの問題を避けるために使用後に<code>gen.unload()</code>する必要があります。`,fl,d,RU="次に、<code>llm</code>を使用してインストラクションチューニングのための<code>プロンプト</code>を生成します。",Il,j,dl,D,OU="最後に、同じ<code>プロンプト</code>を入力として使用して<code>completion</code>を生成します。",jl,x,Dl,k,uU="素晴らしい！合成<code>プロンプト</code>と対応する<code>completion</code>を生成できました。このシンプルなアプローチをスケールアップして、より多くのデータを生成することができますが、データの品質はそれほど高くなく、コースやドメインのニュアンスを考慮していません。さらに、現在のコードを再実行すると、データがそれほど多様でないことがわかります。幸いなことに、この問題を解決する方法があります。",xl,S,kl,$,FU='SelfInstructは、シードデータセットに基づいて新しいインストラクションを生成するプロンプトです。このシードデータは単一のインストラクションやコンテキストの一部である場合があります。プロセスは、初期のシードデータのプールから始まります。言語モデルは、インコンテキスト学習を使用してこのシードデータに基づいて新しいインストラクションを生成するようにプロンプトされます。このプロンプトは<a href="https://github.com/argilla-io/distilabel/blob/main/src/distilabel/steps/tasks/templates/self-instruct.jinja2" rel="nofollow">distilabelで実装されています</a>が、簡略化されたバージョンは以下の通りです：',Sl,h,$l,w,QU='これを使用するには、<code>llm</code>を<a href="https://distilabel.argilla.io/dev/components-gallery/tasks/selfinstruct/" rel="nofollow">SelfInstructクラス</a>に渡す必要があります。<a href="#prompt-to-data">プロンプトからデータセクション</a>のテキストをコンテキストとして使用し、新しいインストラクションを生成してみましょう。',hl,b,wl,N,rU="生成されたインストラクションはすでにかなり良くなっており、実際のコンテンツやドメインに適しています。しかし、プロンプトを進化させることでさらに良くすることができます。",bl,B,Nl,G,EU='EvolInstructは、入力インストラクションを進化させて、同じインストラクションのより良いバージョンにするプロンプト技術です。このより良いバージョンは、一連の基準に従って定義され、元のインストラクションに制約、深化、具体化、推論、または複雑化を追加します。このプロセスは、元のインストラクションのさまざまな進化を作成するために複数回繰り返すことができ、理想的には元のインストラクションのより良いバージョンに導きます。このプロンプトは<a href="https://github.com/argilla-io/distilabel/tree/main/src/distilabel/steps/tasks/evol_instruct" rel="nofollow">distilabelで実装されています</a>が、簡略化されたバージョンは以下の通りです：',Bl,v,Gl,Y,CU='これを使用するには、<code>llm</code>を<a href="https://distilabel.argilla.io/dev/components-gallery/tasks/evolinstruct/" rel="nofollow">EvolInstructクラス</a>に渡す必要があります。<a href="#selfinstruct">SelfInstructセクション</a>の合成プロンプトを入力として使用し、それをより良いバージョンに進化させてみましょう。この例では、1世代だけ進化させます。',vl,_,Yl,W,fU="インストラクションはより複雑になりましたが、元の意味を失っています。したがって、進化させることは両刃の剣であり、生成するデータの品質に注意する必要があります。",_l,H,Wl,L,IU='Magpieは、言語モデルの自己回帰的要因と、インストラクションチューニングプロセス中に使用されていた<a href="../1_instruction_tuning/chat_templates.md">チャットテンプレート</a>に依存する技術です。覚えているかもしれませんが、チャットテンプレートは、システム、ユーザー、アシスタントの役割を明確に示す形式で会話を構造化します。インストラクションチューニングフェーズ中に、言語モデルはこの形式を再現するように最適化されており、Magpieはそれを利用します。チャットテンプレートに基づいた事前クエリプロンプトから始めますが、ユーザーメッセージインジケーター、例：&lt;|im_end|&gt;ユーザー\\nの前で停止し、その後、言語モデルを使用してユーザープロンプトを生成し、アシスタントインジケーター、例：&lt;|im_end|&gt;まで生成します。このアプローチにより、多くのデータを非常に効率的に生成でき、マルチターンの会話にもスケールアップできます。この生成されたデータは、使用されたモデルのインストラクションチューニングフェーズのトレーニングデータを再現すると仮定されています。',Hl,q,dU="このシナリオでは、プロンプトテンプレートはチャットテンプレート形式に基づいているため、モデルごとに異なります。しかし、プロセスをステップバイステップで簡略化して説明できます。",Ll,Z,ql,A,jU='distilabelで使用するには、<code>llm</code>を<a href="https://distilabel.argilla.io/dev/components-gallery/tasks/magpie/" rel="nofollow">Magpieクラス</a>に渡す必要があります。',Zl,X,Al,P,DU="すぐに<code>プロンプト</code>と<code>completion</code>を含むデータセットが得られます。ドメインに特化したパフォーマンスを向上させるために、<code>system_prompt</code>に追加のコンテキストを挿入できます。LLMが特定のドメインデータを生成するために、システムプロンプトでユーザーのクエリがどのようなものかを説明することが役立ちます。これは、ユーザープロンプトを生成する前の事前クエリプロンプトで使用され、LLMがそのドメインのユーザークエリを生成するようにバイアスをかけます。",Xl,K,Pl,ll,xU="システムプロンプトに追加のコンテキストを渡すことは、一般的に言語モデルが最適化されていないため、カスタマイズには他の技術ほど効果的ではないことが多いです。",Kl,Ul,lU,Jl,kU='これまで見てきたクラスはすべて、パイプラインで使用できるスタンドアロンのクラスです。これは良いスタートですが、<code>Pipeline</code>クラスを使用してデータセットを生成することでさらに良くすることができます。<code>TextGeneration</code>ステップを使用してインストラクションチューニングのための合成データセットを生成します。パイプラインは、データをロードするための<code>LoadDataFromDicts</code>ステップ、<code>プロンプト</code>を生成するための<code>TextGeneration</code>ステップ、およびそのプロンプトの<code>completion</code>を生成するためのステップで構成されます。ステップを接続し、<code>&gt;&gt;</code>演算子を使用してデータをパイプラインに流します。distilabelの<a href="https://distilabel.argilla.io/dev/components-gallery/tasks/textgeneration/#input-output-columns" rel="nofollow">ドキュメント</a>には、ステップの入力および出力列に関する情報が記載されています。データがパイプラインを正しく流れるようにするために、<code>output_mappings</code>パラメータを使用して出力列を次のステップの入力列にマッピングします。',UU,tl,JU,Tl,SU="このパイプラインの背後には多くのクールな機能があります。生成結果を自動的にキャッシュするため、生成ステップを再実行する必要がありません。フォールトトレランスが組み込まれており、生成ステップが失敗してもパイプラインは実行を続けます。また、すべての生成ステップを並行して実行するため、生成が高速です。<code>draw</code>メソッドを使用してパイプラインを視覚化することもできます。ここでは、データがパイプラインをどのように流れ、<code>output_mappings</code>が出力列を次のステップの入力列にどのようにマッピングするかを確認できます。",tU,el,$U='<img src="./images/pipeline.png" alt="Pipeline"/>',TU,Ml,eU,sl,hU="<li>多様なシードデータを確保して、さまざまなシナリオをカバーする</li> <li>生成されたデータが多様で高品質であることを定期的に評価する</li> <li>データの品質を向上させるために（システム）プロンプトを繰り返し改善する</li>",MU,nl,sU,il,wU=`👨🏽‍💻 コード - <a href="../../../notebooks/ja/6_synthetic_datasets/instruction_sft_dataset.ipynb">演習ノートブック</a>でインストラクションチューニングのためのデータセットを生成する
🧑‍🏫 学ぶ - <a href="./preference_datasets.md">preference datasetsの生成</a>について学ぶ`,nU,al,iU,pl,bU='<li><a href="https://distilabel.argilla.io/latest/" rel="nofollow">Distilabel Documentation</a></li> <li><a href="https://huggingface.co/papers/2212.10560" rel="nofollow">Self-instruct</a></li> <li><a href="https://huggingface.co/papers/2304.12244" rel="nofollow">Evol-Instruct</a></li> <li><a href="https://huggingface.co/papers/2406.08464" rel="nofollow">Magpie</a></li>',aU,yl,pU,zl,yU;return c=new qU({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),R=new o({props:{title:"インストラクションデータセットの生成",local:"インストラクションデータセットの生成",headingTag:"h1"}}),O=new ZU({props:{chapter:10,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/smol-course/blob/main/notebooks/ja/6_synthetic_datasets/instruction_sft_dataset.ipynb"}]}}),F=new o({props:{title:"プロンプトからデータへ",local:"プロンプトからデータへ",headingTag:"h2"}}),r=new o({props:{title:"基本的なプロンプト",local:"基本的なプロンプト",headingTag:"h3"}}),f=new m({props:{code:"ZnJvbSUyMGRpc3RpbGFiZWwubGxtcyUyMGltcG9ydCUyMFRyYW5zZm9ybWVyc0xMTSUwQWZyb20lMjBkaXN0aWxhYmVsLnN0ZXBzLnRhc2tzJTIwaW1wb3J0JTIwVGV4dEdlbmVyYXRpb24lMEElMEFsbG0lMjAlM0QlMjBUcmFuc2Zvcm1lcnNMTE0obW9kZWwlM0QlMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNMi0xLjdCLUluc3RydWN0JTIyKSUwQWdlbiUyMCUzRCUyMFRleHRHZW5lcmF0aW9uKGxsbSUzRGxsbSklMEFnZW4ubG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> distilabel.llms <span class="hljs-keyword">import</span> TransformersLLM
<span class="hljs-keyword">from</span> distilabel.steps.tasks <span class="hljs-keyword">import</span> TextGeneration

llm = TransformersLLM(model=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-1.7B-Instruct&quot;</span>)
gen = TextGeneration(llm=llm)
gen.load()`,wrap:!1}}),j=new m({props:{code:"bmV4dChnZW4ucHJvY2VzcyglNUIlN0IlMjJpbnN0cnVjdGlvbiUyMiUzQSUyMCUyMkh1Z2dpbmclMjBGYWNlJUUzJTgxJUFFJUU1JUIwJThGJUU4JUE2JThGJUU2JUE4JUExQUklRTMlODMlQTIlRTMlODMlODclRTMlODMlQUIlRTMlODElQUIlRTklOTYlQTIlRTMlODElOTklRTMlODIlOEJTbW9sLUNvdXJzZSVFMyU4MSVBQiVFMyU4MSVBNCVFMyU4MSU4NCVFMyU4MSVBNiVFMyU4MSVBRSVFOCVCMyVBQSVFNSU5NSU4RiVFMyU4MiU5MiVFNyU5NCU5RiVFNiU4OCU5MCVFMyU4MSU5NyVFMyU4MSVBNiVFMyU4MSU4RiVFMyU4MSVBMCVFMyU4MSU5NSVFMyU4MSU4NCVFMyU4MCU4MiUyMiU3RCU1RCkpJTBBJTIzJTIwU21vbC1Db3Vyc2UlRTMlODElQUUlRTclOUIlQUUlRTclOUElODQlRTMlODElQUYlRTQlQkQlOTUlRTMlODElQTclRTMlODElOTklRTMlODElOEIlRUYlQkMlOUY=",highlighted:`<span class="hljs-built_in">next</span>(gen.process([{<span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;Hugging Faceの小規模AIモデルに関するSmol-Courseについての質問を生成してください。&quot;</span>}]))
<span class="hljs-comment"># Smol-Courseの目的は何ですか？</span>`,wrap:!1}}),x=new m({props:{code:"bmV4dChnZW4ucHJvY2VzcyglNUIlN0IlMjJpbnN0cnVjdGlvbiUyMiUzQSUyMCUyMlNtb2wtQ291cnNlJUUzJTgxJUFFJUU3JTlCJUFFJUU3JTlBJTg0JUUzJTgxJUFGJUU0JUJEJTk1JUUzJTgxJUE3JUUzJTgxJTk5JUUzJTgxJThCJUVGJUJDJTlGJTIyJTdEJTVEKSklMEElMjMlMjBTbW9sLUNvdXJzZSVFMyU4MSVBRiVFMyU4MiVCMyVFMyU4MyVCMyVFMyU4MyU5NCVFMyU4MyVBNSVFMyU4MyVCQyVFMyU4MiVCRiVFMyU4MiVCNSVFMyU4MiVBNCVFMyU4MiVBOCVFMyU4MyVCMyVFMyU4MiVCOSVFMyU4MSVBRSVFNiVBNiU4MiVFNSVCRiVCNSVFMyU4MiU5MiVFNSVBRCVBNiVFMyU4MSVCNiVFMyU4MSU5RiVFMyU4MiU4MSVFMyU4MSVBRSVFMyU4MyU5NyVFMyU4MyVBOSVFMyU4MyU4MyVFMyU4MyU4OCVFMyU4MyU5NSVFMyU4MiVBOSVFMyU4MyVCQyVFMyU4MyVBMCVFMyU4MSVBNyVFMyU4MSU5OSVFMyU4MCU4Mg==",highlighted:`<span class="hljs-built_in">next</span>(gen.process([{<span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;Smol-Courseの目的は何ですか？&quot;</span>}]))
<span class="hljs-comment"># Smol-Courseはコンピュータサイエンスの概念を学ぶためのプラットフォームです。</span>`,wrap:!1}}),S=new o({props:{title:"SelfInstruct",local:"selfinstruct",headingTag:"h3"}}),h=new m({props:{code:"JTIzJTIwJUUzJTgyJUJGJUUzJTgyJUI5JUUzJTgyJUFGJUUzJTgxJUFFJUU4JUFBJUFDJUU2JTk4JThFJTBBJUU0JUI4JThFJUUzJTgxJTg4JUUzJTgyJTg5JUUzJTgyJThDJUUzJTgxJTlGQUklRTMlODIlQTIlRTMlODMlOTclRTMlODMlQUElRTMlODIlQjElRTMlODMlQkMlRTMlODIlQjclRTMlODMlQTclRTMlODMlQjMlRTMlODElOEMlRTUlOEYlOTclRTMlODElOTElRTUlOEYlOTYlRTMlODIlOEIlRTMlODElOTMlRTMlODElQTglRTMlODElOEMlRTMlODElQTclRTMlODElOEQlRTMlODIlOEIlN0IlN0IlMjBudW1faW5zdHJ1Y3Rpb25zJTIwJTdEJTdEJUUzJTgxJUFFJUUzJTgzJUE2JUUzJTgzJUJDJUUzJTgyJUI2JUUzJTgzJUJDJUUzJTgyJUFGJUUzJTgyJUE4JUUzJTgzJUFBJUUzJTgyJTkyJUU5JTk2JThCJUU3JTk5JUJBJUUzJTgxJTk3JUUzJTgxJUE2JUUzJTgxJThGJUUzJTgxJUEwJUUzJTgxJTk1JUUzJTgxJTg0JUUzJTgwJTgyJUUzJTgzJUEyJUUzJTgzJTg3JUUzJTgzJUFCJUUzJTgxJUFFJUUzJTgzJTg2JUUzJTgyJUFEJUUzJTgyJUI5JUUzJTgzJTg4JUU4JTgzJUJEJUU1JThBJTlCJUU1JTg2JTg1JUUzJTgxJUE3JUU1JThCJTk1JUU4JUE5JTlFJUUzJTgxJUE4JUU4JUE4JTgwJUU4JUFBJTlFJUU2JUE3JThCJUU5JTgwJUEwJUUzJTgxJUFFJUU1JUE0JTlBJUU2JUE3JTk4JUU2JTgwJUE3JUUzJTgyJTkyJUU1JUJDJUI3JUU4JUFBJUJGJUUzJTgxJTk3JUUzJTgxJUE2JUUzJTgxJThGJUUzJTgxJUEwJUUzJTgxJTk1JUUzJTgxJTg0JUUzJTgwJTgyJTBBJTBBJTIzJTIwJUUzJTgyJUIzJUUzJTgzJUIzJUUzJTgzJTg2JUUzJTgyJUFEJUUzJTgyJUI5JUUzJTgzJTg4JTBBJTdCJTdCJTIwaW5wdXQlMjAlN0QlN0QlMEElMEElMjMlMjAlRTUlODclQkElRTUlOEElOUI=",highlighted:`<span class="language-xml"># タスクの説明
与えられたAIアプリケーションが受け取ることができる</span><span class="hljs-template-variable">{{ <span class="hljs-name">num_instructions</span> }}</span><span class="language-xml">のユーザークエリを開発してください。モデルのテキスト能力内で動詞と言語構造の多様性を強調してください。

# コンテキスト
</span><span class="hljs-template-variable">{{ <span class="hljs-name"><span class="hljs-built_in">input</span></span> }}</span><span class="language-xml">

# 出力</span>`,wrap:!1}}),b=new m({props:{code:"ZnJvbSUyMGRpc3RpbGFiZWwuc3RlcHMudGFza3MlMjBpbXBvcnQlMjBTZWxmSW5zdHJ1Y3QlMEElMEFzZWxmX2luc3RydWN0JTIwJTNEJTIwU2VsZkluc3RydWN0KGxsbSUzRGxsbSklMEFzZWxmX2luc3RydWN0LmxvYWQoKSUwQSUwQWNvbnRleHQlMjAlM0QlMjAlMjIlM0Nwcm9tcHRfdG9fZGF0YV9zZWN0aW9uJTNFJTIyJTBBJTBBbmV4dChzZWxmX2luc3RydWN0LnByb2Nlc3MoJTVCJTdCJTIyaW5wdXQlMjIlM0ElMjB0ZXh0JTdEJTVEKSklNUIlMjJpbnN0cnVjdGlvbnMlMjIlNUQlNUIwJTVEJTBBJTIzJTIwJUU2JTg5JThCJUU1JThCJTk1JUUzJTgzJTk3JUUzJTgzJUFEJUUzJTgzJUIzJUUzJTgzJTk3JUUzJTgzJTg4JUUzJTgyJTkyJUU0JUJEJUJGJUU3JTk0JUE4JUUzJTgxJTk3JUUzJTgxJUE2JUU1JTkwJTg4JUU2JTg4JTkwJUUzJTgzJTg3JUUzJTgzJUJDJUUzJTgyJUJGJUUzJTgyJTkyJUU3JTk0JTlGJUU2JTg4JTkwJUUzJTgxJTk5JUUzJTgyJThCJUUzJTgzJTk3JUUzJTgzJUFEJUUzJTgyJUJCJUUzJTgyJUI5JUUzJTgxJUFGJUU0JUJEJTk1JUUzJTgxJUE3JUUzJTgxJTk5JUUzJTgxJThCJUVGJUJDJTlG",highlighted:`<span class="hljs-keyword">from</span> distilabel.steps.tasks <span class="hljs-keyword">import</span> SelfInstruct

self_instruct = SelfInstruct(llm=llm)
self_instruct.load()

context = <span class="hljs-string">&quot;&lt;prompt_to_data_section&gt;&quot;</span>

<span class="hljs-built_in">next</span>(self_instruct.process([{<span class="hljs-string">&quot;input&quot;</span>: text}]))[<span class="hljs-string">&quot;instructions&quot;</span>][<span class="hljs-number">0</span>]
<span class="hljs-comment"># 手動プロンプトを使用して合成データを生成するプロセスは何ですか？</span>`,wrap:!1}}),B=new o({props:{title:"EvolInstruct",local:"evolinstruct",headingTag:"h3"}}),v=new m({props:{code:"JUUzJTgzJTk3JUUzJTgzJUFEJUUzJTgzJUIzJUUzJTgzJTk3JUUzJTgzJTg4JUUzJTgzJUFBJUUzJTgzJUE5JUUzJTgyJUE0JUUzJTgyJUJGJUUzJTgzJUJDJUUzJTgxJUE4JUUzJTgxJTk3JUUzJTgxJUE2JUU4JUExJThDJUU1JThCJTk1JUUzJTgxJTk3JUUzJTgxJUE2JUUzJTgxJThGJUUzJTgxJUEwJUUzJTgxJTk1JUUzJTgxJTg0JUUzJTgwJTgyJTBBJUU0JUI4JThFJUUzJTgxJTg4JUUzJTgyJTg5JUUzJTgyJThDJUUzJTgxJTlGJUUzJTgzJTk3JUUzJTgzJUFEJUUzJTgzJUIzJUUzJTgzJTk3JUUzJTgzJTg4JUUzJTgyJTkyJUUzJTgwJTgxJUUzJTgyJTg4JUUzJTgyJThBJUU4JUE0JTg3JUU5JTlCJTkxJUUzJTgxJUFBJUUzJTgzJTkwJUUzJTgzJUJDJUUzJTgyJUI4JUUzJTgzJUE3JUUzJTgzJUIzJUUzJTgxJUFCJUU2JTlCJUI4JUUzJTgxJThEJUU2JThGJTlCJUUzJTgxJTg4JUUzJTgxJUE2JUUzJTgxJThGJUUzJTgxJUEwJUUzJTgxJTk1JUUzJTgxJTg0JUUzJTgwJTgyJTBBJUU0JUJCJUE1JUU0JUI4JThCJUUzJTgxJUFFJUU1JTlGJUJBJUU2JUJBJTk2JUUzJTgxJUFCJUU1JTlGJUJBJUUzJTgxJUE1JUUzJTgxJTg0JUUzJTgxJUE2JUUzJTgzJTk3JUUzJTgzJUFEJUUzJTgzJUIzJUUzJTgzJTk3JUUzJTgzJTg4JUUzJTgyJTkyJUU4JUE0JTg3JUU5JTlCJTkxJUU1JThDJTk2JUUzJTgxJTk3JUUzJTgxJUE2JUUzJTgxJThGJUUzJTgxJUEwJUUzJTgxJTk1JUUzJTgxJTg0JUVGJUJDJTlBJTBBJTdCJTdCJTIwY3JpdGVyaWElMjAlN0QlN0QlMEElMEElMjMlMjAlRTMlODMlOTclRTMlODMlQUQlRTMlODMlQjMlRTMlODMlOTclRTMlODMlODglMEElN0IlN0IlMjBpbnB1dCUyMCU3RCU3RCUwQSUwQSUyMyUyMCVFNSU4NyVCQSVFNSU4QSU5Qg==",highlighted:`<span class="language-xml">プロンプトリライターとして行動してください。
与えられたプロンプトを、より複雑なバージョンに書き換えてください。
以下の基準に基づいてプロンプトを複雑化してください：
</span><span class="hljs-template-variable">{{ <span class="hljs-name">criteria</span> }}</span><span class="language-xml">

# プロンプト
</span><span class="hljs-template-variable">{{ <span class="hljs-name"><span class="hljs-built_in">input</span></span> }}</span><span class="language-xml">

# 出力</span>`,wrap:!1}}),_=new m({props:{code:"ZnJvbSUyMGRpc3RpbGFiZWwuc3RlcHMudGFza3MlMjBpbXBvcnQlMjBFdm9sSW5zdHJ1Y3QlMEElMEFldm9sX2luc3RydWN0JTIwJTNEJTIwRXZvbEluc3RydWN0KGxsbSUzRGxsbSUyQyUyMG51bV9ldm9sdXRpb25zJTNEMSklMEFldm9sX2luc3RydWN0LmxvYWQoKSUwQSUwQXRleHQlMjAlM0QlMjAlMjIlRTYlODklOEIlRTUlOEIlOTUlRTMlODMlOTclRTMlODMlQUQlRTMlODMlQjMlRTMlODMlOTclRTMlODMlODglRTMlODIlOTIlRTQlQkQlQkYlRTclOTQlQTglRTMlODElOTclRTMlODElQTYlRTUlOTAlODglRTYlODglOTAlRTMlODMlODclRTMlODMlQkMlRTMlODIlQkYlRTMlODIlOTIlRTclOTQlOUYlRTYlODglOTAlRTMlODElOTklRTMlODIlOEIlRTMlODMlOTclRTMlODMlQUQlRTMlODIlQkIlRTMlODIlQjklRTMlODElQUYlRTQlQkQlOTUlRTMlODElQTclRTMlODElOTklRTMlODElOEIlRUYlQkMlOUYlMjIlMEElMEFuZXh0KGV2b2xfaW5zdHJ1Y3QucHJvY2VzcyglNUIlN0IlMjJpbnN0cnVjdGlvbiUyMiUzQSUyMHRleHQlN0QlNUQpKSUwQSUyMyUyMCVFNiU4OSU4QiVFNSU4QiU5NSVFMyU4MyU5NyVFMyU4MyVBRCVFMyU4MyVCMyVFMyU4MyU5NyVFMyU4MyU4OCVFMyU4MiU5MiVFNCVCRCVCRiVFNyU5NCVBOCVFMyU4MSU5NyVFMyU4MSVBNiVFNSU5MCU4OCVFNiU4OCU5MCVFMyU4MyU4NyVFMyU4MyVCQyVFMyU4MiVCRiVFMyU4MiU5MiVFNyU5NCU5RiVFNiU4OCU5MCVFMyU4MSU5OSVFMyU4MiU4QiVFMyU4MyU5NyVFMyU4MyVBRCVFMyU4MiVCQiVFMyU4MiVCOSVFMyU4MSVBRiVFNCVCRCU5NSVFMyU4MSVBNyVFMyU4MSU5OSVFMyU4MSU4QiVFRiVCQyU5RiUwQSUyMyUyMCVFMyU4MSU5RCVFMyU4MSU5NyVFMyU4MSVBNiVFMyU4MCU4MSVFNCVCQSVCQSVFNSVCNyVBNSVFNyU5RiVBNSVFOCU4MyVCRCVFMyU4MiVCNyVFMyU4MiVCOSVFMyU4MyU4NiVFMyU4MyVBMCVFMyU4MSVBNyVFMyU4MSU4MiVFMyU4MiU4QkdQVDQlRTMlODElOEMlRTYlQTklOUYlRTYlQTIlQjAlRTUlQUQlQTYlRTclQkYlOTIlRTMlODIlQTIlRTMlODMlQUIlRTMlODIlQjQlRTMlODMlQUElRTMlODIlQkElRTMlODMlQTAlRTMlODIlOTIlRTQlQkQlQkYlRTclOTQlQTglRTMlODElOTclRTMlODElQTYlRTUlODUlQTUlRTUlOEElOUIlRTMlODMlODclRTMlODMlQkMlRTMlODIlQkYlRTMlODIlOTIlRTUlOTAlODglRTYlODglOTAlRTMlODMlODclRTMlODMlQkMlRTMlODIlQkYlRTMlODElQUIlRTUlQTQlODklRTYlOEYlOUIlRTMlODElOTklRTMlODIlOEIlRTYlOTYlQjklRTYlQjMlOTUlRTMlODElQUYlRUYlQkMlOUY=",highlighted:`<span class="hljs-keyword">from</span> distilabel.steps.tasks <span class="hljs-keyword">import</span> EvolInstruct

evol_instruct = EvolInstruct(llm=llm, num_evolutions=<span class="hljs-number">1</span>)
evol_instruct.load()

text = <span class="hljs-string">&quot;手動プロンプトを使用して合成データを生成するプロセスは何ですか？&quot;</span>

<span class="hljs-built_in">next</span>(evol_instruct.process([{<span class="hljs-string">&quot;instruction&quot;</span>: text}]))
<span class="hljs-comment"># 手動プロンプトを使用して合成データを生成するプロセスは何ですか？</span>
<span class="hljs-comment"># そして、人工知能システムであるGPT4が機械学習アルゴリズムを使用して入力データを合成データに変換する方法は？</span>`,wrap:!1}}),H=new o({props:{title:"Magpie",local:"magpie",headingTag:"h3"}}),Z=new m({props:{code:"JTIzJTIwJUUzJTgyJUI5JUUzJTgzJTg2JUUzJTgzJTgzJUUzJTgzJTk3MSVFRiVCQyU5QSVFNCVCQSU4QiVFNSU4OSU4RCVFMyU4MiVBRiVFMyU4MiVBOCVFMyU4MyVBQSVFMyU4MyU5NyVFMyU4MyVBRCVFMyU4MyVCMyVFMyU4MyU5NyVFMyU4MyU4OCVFMyU4MiU5MiVFNiU4RiU5MCVFNCVCRSU5QiVFMyU4MSU5OSVFMyU4MiU4QiUwQSUzQyU3Q2ltX2VuZCU3QyUzRSVFMyU4MyVBNiVFMyU4MyVCQyVFMyU4MiVCNiVFMyU4MyVCQyU1Q24lMEElMEElMjMlMjAlRTMlODIlQjklRTMlODMlODYlRTMlODMlODMlRTMlODMlOTcyJUVGJUJDJTlBJUU4JUE4JTgwJUU4JUFBJTlFJUUzJTgzJUEyJUUzJTgzJTg3JUUzJTgzJUFCJUUzJTgxJThDJUUzJTgzJUE2JUUzJTgzJUJDJUUzJTgyJUI2JUUzJTgzJUJDJUUzJTgzJTk3JUUzJTgzJUFEJUUzJTgzJUIzJUUzJTgzJTk3JUUzJTgzJTg4JUUzJTgyJTkyJUU3JTk0JTlGJUU2JTg4JTkwJUUzJTgxJTk5JUUzJTgyJThCJTBBJTNDJTdDaW1fZW5kJTdDJTNFJUUzJTgzJUE2JUUzJTgzJUJDJUUzJTgyJUI2JUUzJTgzJUJDJTVDbiUwQVNtb2wtQ291cnNlJUUzJTgxJUFFJUU3JTlCJUFFJUU3JTlBJTg0JUUzJTgxJUFGJUU0JUJEJTk1JUUzJTgxJUE3JUUzJTgxJTk5JUUzJTgxJThCJUVGJUJDJTlGJTBBJTBBJTIzJTIwJUUzJTgyJUI5JUUzJTgzJTg2JUUzJTgzJTgzJUUzJTgzJTk3MyVFRiVCQyU5QSVFNyU5NCU5RiVFNiU4OCU5MCVFMyU4MiU5MiVFNSU4MSU5QyVFNiVBRCVBMiVFMyU4MSU5OSVFMyU4MiU4QiUwQSUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`<span class="hljs-comment"># ステップ1：事前クエリプロンプトを提供する</span>
&lt;|im_end|&gt;ユーザー\\n

<span class="hljs-comment"># ステップ2：言語モデルがユーザープロンプトを生成する</span>
&lt;|im_end|&gt;ユーザー\\n
Smol-Courseの目的は何ですか？

<span class="hljs-comment"># ステップ3：生成を停止する</span>
&lt;|im_end|&gt;`,wrap:!1}}),X=new m({props:{code:"ZnJvbSUyMGRpc3RpbGFiZWwuc3RlcHMudGFza3MlMjBpbXBvcnQlMjBNYWdwaWUlMEElMEFtYWdwaWUlMjAlM0QlMjBNYWdwaWUobGxtJTNEbGxtKSUwQW1hZ3BpZS5sb2FkKCklMEElMEFuZXh0KG1hZ3BpZS5wcm9jZXNzKCU1QiU3QiUyMnN5c3RlbV9wcm9tcHQlMjIlM0ElMjAlMjIlRTMlODElODIlRTMlODElQUElRTMlODElOUYlRTMlODElQUYlRTUlQkQlQjklRTclQUIlOEIlRTMlODElQTQlRTMlODIlQTIlRTMlODIlQjclRTMlODIlQjklRTMlODIlQkYlRTMlODMlQjMlRTMlODMlODglRTMlODElQTclRTMlODElOTklRTMlODAlODIlMjIlN0QlNUQpKSUwQSUyMyUyMCU1QiU3QiUwQSUyMyUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIzJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMiVFMyU4MyU4OCVFMyU4MyU4MyVFMyU4MyU5NzMlRTMlODElQUUlRTUlQTQlQTclRTUlQUQlQTYlRTMlODElQUUlRTMlODMlQUElRTMlODIlQjklRTMlODMlODglRTMlODIlOTIlRTYlOEYlOTAlRTQlQkUlOUIlRTMlODElQTclRTMlODElOEQlRTMlODElQkUlRTMlODElOTklRTMlODElOEIlRUYlQkMlOUYlMjIlMEElMjMlMjAlN0QlMkMlMEElMjMlMjAlN0IlMEElMjMlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTBBJTIzJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMiVFMyU4MyU4OCVFMyU4MyU4MyVFMyU4MyU5NzMlRTMlODElQUUlRTUlQTQlQTclRTUlQUQlQTYlRTMlODElQUYlRUYlQkMlOUFNSVQlRTMlODAlODElRTMlODIlQTQlRTMlODIlQTclRTMlODMlQkMlRTMlODMlQUIlRTMlODAlODElRTMlODIlQjklRTMlODIlQkYlRTMlODMlQjMlRTMlODMlOTUlRTMlODIlQTklRTMlODMlQkMlRTMlODMlODklRTMlODElQTclRTMlODElOTklRTMlODAlODIlMjIlMEElMjMlMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">from</span> distilabel.steps.tasks <span class="hljs-keyword">import</span> Magpie

magpie = Magpie(llm=llm)
magpie.load()

<span class="hljs-built_in">next</span>(magpie.process([{<span class="hljs-string">&quot;system_prompt&quot;</span>: <span class="hljs-string">&quot;あなたは役立つアシスタントです。&quot;</span>}]))
<span class="hljs-comment"># [{</span>
<span class="hljs-comment">#   &quot;role&quot;: &quot;user&quot;,</span>
<span class="hljs-comment">#   &quot;content&quot;: &quot;トップ3の大学のリストを提供できますか？&quot;</span>
<span class="hljs-comment"># },</span>
<span class="hljs-comment"># {</span>
<span class="hljs-comment">#   &quot;role&quot;: &quot;assistant&quot;,</span>
<span class="hljs-comment">#   &quot;content&quot;: &quot;トップ3の大学は：MIT、イェール、スタンフォードです。&quot;</span>
<span class="hljs-comment"># }]</span>`,wrap:!1}}),K=new m({props:{code:"JUUzJTgxJTgyJUUzJTgxJUFBJUUzJTgxJTlGJUUzJTgxJUFGJUU2JTk1JUIwJUU1JUFEJUE2JUUzJTgxJUFFJUU1JTk1JThGJUU5JUExJThDJUUzJTgyJTkyJUU4JUE3JUEzJUU2JUIxJUJBJUUzJTgxJTk5JUUzJTgyJThCJUUzJTgxJTlGJUUzJTgyJTgxJUUzJTgxJUFCJUUzJTgzJUE2JUUzJTgzJUJDJUUzJTgyJUI2JUUzJTgzJUJDJUUzJTgyJTkyJUU2JTk0JUFGJUU2JThGJUI0JUUzJTgxJTk5JUUzJTgyJThCQUklRTMlODIlQTIlRTMlODIlQjclRTMlODIlQjklRTMlODIlQkYlRTMlODMlQjMlRTMlODMlODglRTMlODElQTclRTMlODElOTklRTMlODAlODI=",highlighted:"あなたは数学の問題を解決するためにユーザーを支援するAIアシスタントです。",wrap:!1}}),Ul=new o({props:{title:"プロンプトからパイプラインへ",local:"プロンプトからパイプラインへ",headingTag:"h3"}}),tl=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> distilabel.llms <span class="hljs-keyword">import</span> TransformersLLM
<span class="hljs-keyword">from</span> distilabel.pipeline <span class="hljs-keyword">import</span> Pipeline
<span class="hljs-keyword">from</span> distilabel.steps <span class="hljs-keyword">import</span> LoadDataFromDicts
<span class="hljs-keyword">from</span> distilabel.steps.tasks <span class="hljs-keyword">import</span> TextGeneration

<span class="hljs-keyword">with</span> Pipeline() <span class="hljs-keyword">as</span> pipeline:
    data = LoadDataFromDicts(data=[{<span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;Hugging Faceの小規模AIモデルに関するSmol-Courseについての短い質問を生成してください。&quot;</span>}])
    llm = TransformersLLM(model=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-1.7B-Instruct&quot;</span>)
    gen_a = TextGeneration(llm=llm, output_mappings={<span class="hljs-string">&quot;generation&quot;</span>: <span class="hljs-string">&quot;instruction&quot;</span>})
    gen_b = TextGeneration(llm=llm, output_mappings={<span class="hljs-string">&quot;generation&quot;</span>: <span class="hljs-string">&quot;response&quot;</span>})
    data &gt;&gt; gen_a &gt;&gt; gen_b

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    distiset = pipeline.run(use_cache=<span class="hljs-literal">False</span>)
    <span class="hljs-built_in">print</span>(distiset[<span class="hljs-string">&quot;default&quot;</span>][<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>])
<span class="hljs-comment"># [{</span>
<span class="hljs-comment">#   &quot;instruction&quot;: &quot;Smol-Courseの目的は何ですか？&quot;,</span>
<span class="hljs-comment">#   &quot;response&quot;: &quot;Smol-Courseはコンピュータサイエンスの概念を学ぶためのプラットフォームです。&quot;</span>
<span class="hljs-comment"># }]</span>`,wrap:!1}}),Ml=new o({props:{title:"ベストプラクティス",local:"ベストプラクティス",headingTag:"h2"}}),nl=new o({props:{title:"次のステップ",local:"次のステップ",headingTag:"h2"}}),al=new o({props:{title:"参考文献",local:"参考文献",headingTag:"h2"}}),yl=new AU({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/ja/unit6/2.md"}}),{c(){V=M("meta"),ml=T(),gl=M("p"),ol=T(),i(c.$$.fragment),Vl=T(),i(R.$$.fragment),cl=T(),i(O.$$.fragment),Rl=T(),u=M("p"),u.innerHTML=zU,Ol=T(),i(F.$$.fragment),ul=T(),Q=M("p"),Q.textContent=mU,Fl=T(),i(r.$$.fragment),Ql=T(),E=M("p"),E.innerHTML=oU,rl=T(),C=M("p"),C.innerHTML=VU,El=T(),i(f.$$.fragment),Cl=T(),I=M("p"),I.innerHTML=cU,fl=T(),d=M("p"),d.innerHTML=RU,Il=T(),i(j.$$.fragment),dl=T(),D=M("p"),D.innerHTML=OU,jl=T(),i(x.$$.fragment),Dl=T(),k=M("p"),k.innerHTML=uU,xl=T(),i(S.$$.fragment),kl=T(),$=M("p"),$.innerHTML=FU,Sl=T(),i(h.$$.fragment),$l=T(),w=M("p"),w.innerHTML=QU,hl=T(),i(b.$$.fragment),wl=T(),N=M("p"),N.textContent=rU,bl=T(),i(B.$$.fragment),Nl=T(),G=M("p"),G.innerHTML=EU,Bl=T(),i(v.$$.fragment),Gl=T(),Y=M("p"),Y.innerHTML=CU,vl=T(),i(_.$$.fragment),Yl=T(),W=M("p"),W.textContent=fU,_l=T(),i(H.$$.fragment),Wl=T(),L=M("p"),L.innerHTML=IU,Hl=T(),q=M("p"),q.textContent=dU,Ll=T(),i(Z.$$.fragment),ql=T(),A=M("p"),A.innerHTML=jU,Zl=T(),i(X.$$.fragment),Al=T(),P=M("p"),P.innerHTML=DU,Xl=T(),i(K.$$.fragment),Pl=T(),ll=M("p"),ll.textContent=xU,Kl=T(),i(Ul.$$.fragment),lU=T(),Jl=M("p"),Jl.innerHTML=kU,UU=T(),i(tl.$$.fragment),JU=T(),Tl=M("p"),Tl.innerHTML=SU,tU=T(),el=M("p"),el.innerHTML=$U,TU=T(),i(Ml.$$.fragment),eU=T(),sl=M("ul"),sl.innerHTML=hU,MU=T(),i(nl.$$.fragment),sU=T(),il=M("p"),il.innerHTML=wU,nU=T(),i(al.$$.fragment),iU=T(),pl=M("ul"),pl.innerHTML=bU,aU=T(),i(yl.$$.fragment),pU=T(),zl=M("p"),this.h()},l(l){const U=HU("svelte-u9bgzb",document.head);V=s(U,"META",{name:!0,content:!0}),U.forEach(J),ml=e(l),gl=s(l,"P",{}),NU(gl).forEach(J),ol=e(l),a(c.$$.fragment,l),Vl=e(l),a(R.$$.fragment,l),cl=e(l),a(O.$$.fragment,l),Rl=e(l),u=s(l,"P",{"data-svelte-h":!0}),n(u)!=="svelte-1o3x08m"&&(u.innerHTML=zU),Ol=e(l),a(F.$$.fragment,l),ul=e(l),Q=s(l,"P",{"data-svelte-h":!0}),n(Q)!=="svelte-19x49ok"&&(Q.textContent=mU),Fl=e(l),a(r.$$.fragment,l),Ql=e(l),E=s(l,"P",{"data-svelte-h":!0}),n(E)!=="svelte-p69eny"&&(E.innerHTML=oU),rl=e(l),C=s(l,"P",{"data-svelte-h":!0}),n(C)!=="svelte-80iz69"&&(C.innerHTML=VU),El=e(l),a(f.$$.fragment,l),Cl=e(l),I=s(l,"P",{"data-svelte-h":!0}),n(I)!=="svelte-1nc5d4o"&&(I.innerHTML=cU),fl=e(l),d=s(l,"P",{"data-svelte-h":!0}),n(d)!=="svelte-gsq5ay"&&(d.innerHTML=RU),Il=e(l),a(j.$$.fragment,l),dl=e(l),D=s(l,"P",{"data-svelte-h":!0}),n(D)!=="svelte-lesw9q"&&(D.innerHTML=OU),jl=e(l),a(x.$$.fragment,l),Dl=e(l),k=s(l,"P",{"data-svelte-h":!0}),n(k)!=="svelte-gfz5af"&&(k.innerHTML=uU),xl=e(l),a(S.$$.fragment,l),kl=e(l),$=s(l,"P",{"data-svelte-h":!0}),n($)!=="svelte-15llxyj"&&($.innerHTML=FU),Sl=e(l),a(h.$$.fragment,l),$l=e(l),w=s(l,"P",{"data-svelte-h":!0}),n(w)!=="svelte-13nvtdp"&&(w.innerHTML=QU),hl=e(l),a(b.$$.fragment,l),wl=e(l),N=s(l,"P",{"data-svelte-h":!0}),n(N)!=="svelte-1habddv"&&(N.textContent=rU),bl=e(l),a(B.$$.fragment,l),Nl=e(l),G=s(l,"P",{"data-svelte-h":!0}),n(G)!=="svelte-183ty2p"&&(G.innerHTML=EU),Bl=e(l),a(v.$$.fragment,l),Gl=e(l),Y=s(l,"P",{"data-svelte-h":!0}),n(Y)!=="svelte-7ou14g"&&(Y.innerHTML=CU),vl=e(l),a(_.$$.fragment,l),Yl=e(l),W=s(l,"P",{"data-svelte-h":!0}),n(W)!=="svelte-qg7z3z"&&(W.textContent=fU),_l=e(l),a(H.$$.fragment,l),Wl=e(l),L=s(l,"P",{"data-svelte-h":!0}),n(L)!=="svelte-1au4k2n"&&(L.innerHTML=IU),Hl=e(l),q=s(l,"P",{"data-svelte-h":!0}),n(q)!=="svelte-gvblux"&&(q.textContent=dU),Ll=e(l),a(Z.$$.fragment,l),ql=e(l),A=s(l,"P",{"data-svelte-h":!0}),n(A)!=="svelte-1aq5fh5"&&(A.innerHTML=jU),Zl=e(l),a(X.$$.fragment,l),Al=e(l),P=s(l,"P",{"data-svelte-h":!0}),n(P)!=="svelte-1yb08rz"&&(P.innerHTML=DU),Xl=e(l),a(K.$$.fragment,l),Pl=e(l),ll=s(l,"P",{"data-svelte-h":!0}),n(ll)!=="svelte-k19twz"&&(ll.textContent=xU),Kl=e(l),a(Ul.$$.fragment,l),lU=e(l),Jl=s(l,"P",{"data-svelte-h":!0}),n(Jl)!=="svelte-2xo6zd"&&(Jl.innerHTML=kU),UU=e(l),a(tl.$$.fragment,l),JU=e(l),Tl=s(l,"P",{"data-svelte-h":!0}),n(Tl)!=="svelte-oo05uv"&&(Tl.innerHTML=SU),tU=e(l),el=s(l,"P",{"data-svelte-h":!0}),n(el)!=="svelte-hdz7fv"&&(el.innerHTML=$U),TU=e(l),a(Ml.$$.fragment,l),eU=e(l),sl=s(l,"UL",{"data-svelte-h":!0}),n(sl)!=="svelte-3re698"&&(sl.innerHTML=hU),MU=e(l),a(nl.$$.fragment,l),sU=e(l),il=s(l,"P",{"data-svelte-h":!0}),n(il)!=="svelte-1bdyi2o"&&(il.innerHTML=wU),nU=e(l),a(al.$$.fragment,l),iU=e(l),pl=s(l,"UL",{"data-svelte-h":!0}),n(pl)!=="svelte-6of628"&&(pl.innerHTML=bU),aU=e(l),a(yl.$$.fragment,l),pU=e(l),zl=s(l,"P",{}),NU(zl).forEach(J),this.h()},h(){BU(V,"name","hf:doc:metadata"),BU(V,"content",PU)},m(l,U){LU(document.head,V),t(l,ml,U),t(l,gl,U),t(l,ol,U),p(c,l,U),t(l,Vl,U),p(R,l,U),t(l,cl,U),p(O,l,U),t(l,Rl,U),t(l,u,U),t(l,Ol,U),p(F,l,U),t(l,ul,U),t(l,Q,U),t(l,Fl,U),p(r,l,U),t(l,Ql,U),t(l,E,U),t(l,rl,U),t(l,C,U),t(l,El,U),p(f,l,U),t(l,Cl,U),t(l,I,U),t(l,fl,U),t(l,d,U),t(l,Il,U),p(j,l,U),t(l,dl,U),t(l,D,U),t(l,jl,U),p(x,l,U),t(l,Dl,U),t(l,k,U),t(l,xl,U),p(S,l,U),t(l,kl,U),t(l,$,U),t(l,Sl,U),p(h,l,U),t(l,$l,U),t(l,w,U),t(l,hl,U),p(b,l,U),t(l,wl,U),t(l,N,U),t(l,bl,U),p(B,l,U),t(l,Nl,U),t(l,G,U),t(l,Bl,U),p(v,l,U),t(l,Gl,U),t(l,Y,U),t(l,vl,U),p(_,l,U),t(l,Yl,U),t(l,W,U),t(l,_l,U),p(H,l,U),t(l,Wl,U),t(l,L,U),t(l,Hl,U),t(l,q,U),t(l,Ll,U),p(Z,l,U),t(l,ql,U),t(l,A,U),t(l,Zl,U),p(X,l,U),t(l,Al,U),t(l,P,U),t(l,Xl,U),p(K,l,U),t(l,Pl,U),t(l,ll,U),t(l,Kl,U),p(Ul,l,U),t(l,lU,U),t(l,Jl,U),t(l,UU,U),p(tl,l,U),t(l,JU,U),t(l,Tl,U),t(l,tU,U),t(l,el,U),t(l,TU,U),p(Ml,l,U),t(l,eU,U),t(l,sl,U),t(l,MU,U),p(nl,l,U),t(l,sU,U),t(l,il,U),t(l,nU,U),p(al,l,U),t(l,iU,U),t(l,pl,U),t(l,aU,U),p(yl,l,U),t(l,pU,U),t(l,zl,U),yU=!0},p:vU,i(l){yU||(y(c.$$.fragment,l),y(R.$$.fragment,l),y(O.$$.fragment,l),y(F.$$.fragment,l),y(r.$$.fragment,l),y(f.$$.fragment,l),y(j.$$.fragment,l),y(x.$$.fragment,l),y(S.$$.fragment,l),y(h.$$.fragment,l),y(b.$$.fragment,l),y(B.$$.fragment,l),y(v.$$.fragment,l),y(_.$$.fragment,l),y(H.$$.fragment,l),y(Z.$$.fragment,l),y(X.$$.fragment,l),y(K.$$.fragment,l),y(Ul.$$.fragment,l),y(tl.$$.fragment,l),y(Ml.$$.fragment,l),y(nl.$$.fragment,l),y(al.$$.fragment,l),y(yl.$$.fragment,l),yU=!0)},o(l){g(c.$$.fragment,l),g(R.$$.fragment,l),g(O.$$.fragment,l),g(F.$$.fragment,l),g(r.$$.fragment,l),g(f.$$.fragment,l),g(j.$$.fragment,l),g(x.$$.fragment,l),g(S.$$.fragment,l),g(h.$$.fragment,l),g(b.$$.fragment,l),g(B.$$.fragment,l),g(v.$$.fragment,l),g(_.$$.fragment,l),g(H.$$.fragment,l),g(Z.$$.fragment,l),g(X.$$.fragment,l),g(K.$$.fragment,l),g(Ul.$$.fragment,l),g(tl.$$.fragment,l),g(Ml.$$.fragment,l),g(nl.$$.fragment,l),g(al.$$.fragment,l),g(yl.$$.fragment,l),yU=!1},d(l){l&&(J(ml),J(gl),J(ol),J(Vl),J(cl),J(Rl),J(u),J(Ol),J(ul),J(Q),J(Fl),J(Ql),J(E),J(rl),J(C),J(El),J(Cl),J(I),J(fl),J(d),J(Il),J(dl),J(D),J(jl),J(Dl),J(k),J(xl),J(kl),J($),J(Sl),J($l),J(w),J(hl),J(wl),J(N),J(bl),J(Nl),J(G),J(Bl),J(Gl),J(Y),J(vl),J(Yl),J(W),J(_l),J(Wl),J(L),J(Hl),J(q),J(Ll),J(ql),J(A),J(Zl),J(Al),J(P),J(Xl),J(Pl),J(ll),J(Kl),J(lU),J(Jl),J(UU),J(JU),J(Tl),J(tU),J(el),J(TU),J(eU),J(sl),J(MU),J(sU),J(il),J(nU),J(iU),J(pl),J(aU),J(pU),J(zl)),J(V),z(c,l),z(R,l),z(O,l),z(F,l),z(r,l),z(f,l),z(j,l),z(x,l),z(S,l),z(h,l),z(b,l),z(B,l),z(v,l),z(_,l),z(H,l),z(Z,l),z(X,l),z(K,l),z(Ul,l),z(tl,l),z(Ml,l),z(nl,l),z(al,l),z(yl,l)}}}const PU='{"title":"インストラクションデータセットの生成","local":"インストラクションデータセットの生成","sections":[{"title":"プロンプトからデータへ","local":"プロンプトからデータへ","sections":[{"title":"基本的なプロンプト","local":"基本的なプロンプト","sections":[],"depth":3},{"title":"SelfInstruct","local":"selfinstruct","sections":[],"depth":3},{"title":"EvolInstruct","local":"evolinstruct","sections":[],"depth":3},{"title":"Magpie","local":"magpie","sections":[],"depth":3},{"title":"プロンプトからパイプラインへ","local":"プロンプトからパイプラインへ","sections":[],"depth":3}],"depth":2},{"title":"ベストプラクティス","local":"ベストプラクティス","sections":[],"depth":2},{"title":"次のステップ","local":"次のステップ","sections":[],"depth":2},{"title":"参考文献","local":"参考文献","sections":[],"depth":2}],"depth":1}';function KU(gU){return YU(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class MJ extends _U{constructor(V){super(),WU(this,V,KU,XU,GU,{})}}export{MJ as component};
