# main.py
import wx
import sys
import threading
from core import start_core_system, stop_all_tray_icons
from gui import MainFrame

def run_info_gui(devices, drive_map):
    class DummyApp(wx.App):
        def OnInit(self):
            frame = MainFrame(None, devices=devices, drive_map=drive_map)
            frame.Show()
            wx.CallLater(10000, frame.Close)
            return True

    app = DummyApp(False)
    app.MainLoop()

if __name__ == "__main__":
    try:
        # Starte Tray + Monitoring im Hauptthread
        drive_map = start_core_system()
        devices = list(drive_map.keys())

        # Starte GUI isoliert in einem separaten Thread
        gui_thread = threading.Thread(
            target=run_info_gui,
            args=(devices, drive_map),
            daemon=True
        )
        gui_thread.start()

        print("[INFO] GUI gestartet – wird nach 5s automatisch beendet.")
        print("[INFO] Tray-Überwachung läuft unabhängig weiter...")

        # Warte unendlich (z. B. bis Nutzer über Tray beendet)
        threading.Event().wait()

    except KeyboardInterrupt:
        stop_all_tray_icons()
        sys.exit(0)
