from enum import Enum, auto
import sqlite3
import os

class CPUGroupType(Enum):
    MINING = "mining"
    QEMU = "qemu"
    INFERENCE = "inference"
    STORAGE = "storage"

class CPUStorage:
    def __init__(self, db_path: str = "db/cpu.db"):
        os.makedirs(os.path.dirname(db_path), exist_ok=True)
        self.conn = sqlite3.connect(db_path)
        self.cursor = self.conn.cursor()
        self._init_schema()
        
    def _init_schema(self):
        """Initialize the CPU storage schema"""
        self.cursor.execute('''
            CREATE TABLE IF NOT EXISTS cpu_config (
                cpu_id INTEGER PRIMARY KEY,
                gate_delay REAL,
                switch_freq REAL,
                drift_speed REAL,
                clock_freq REAL,
                group_type TEXT,
                core_count INTEGER DEFAULT 8,
                thread_count INTEGER DEFAULT 16,
                last_updated INTEGER
            )
        ''')
        
        self.cursor.execute('''
            CREATE TABLE IF NOT EXISTS cpu_state (
                cpu_id INTEGER PRIMARY KEY,
                current_task TEXT,
                usage_percent REAL DEFAULT 0,
                temperature REAL DEFAULT 45.0,
                power_draw REAL DEFAULT 65.0,
                last_updated INTEGER
            )
        ''')
        self.conn.commit()

# Create global storage instance
storage = CPUStorage()