from sqlalchemy import create_engine, Column, Integer, String, Float, JSON, Boolean, BigInteger
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy.orm import sessionmaker
from config import get_db_url

Base = declarative_base()

class CPUState(Base):
    __tablename__ = 'cpu_states'
    
    cpu_id = Column(Integer, primary_key=True)
    group_type = Column(String(50))
    core_count = Column(Integer)
    thread_count = Column(Integer)
    busy_cores = Column(Integer)
    busy_threads = Column(Integer)
    last_updated = Column(BigInteger)
    state_data = Column(JSON)
    register_state = Column(JSON)
    
class CPUMemoryState(Base):
    __tablename__ = 'cpu_memory_states'
    
    address = Column(BigInteger, primary_key=True)
    cpu_id = Column(Integer)
    data = Column(String)  # Base64 encoded data
    last_accessed = Column(BigInteger)
    
class CPURegisters(Base):
    __tablename__ = 'cpu_registers'
    
    cpu_id = Column(Integer, primary_key=True)
    register_id = Column(Integer, primary_key=True)
    value = Column(BigInteger)
    last_updated = Column(BigInteger)

def init_db():
    engine = create_engine(get_db_url())
    Base.metadata.create_all(engine)
    return sessionmaker(bind=engine)()
