"""
Simple wallet database viewer
"""
import sqlite3
import json
from datetime import datetime

def view_wallets():
    try:
        # Connect to the database
        conn = sqlite3.connect('wallet_data.db')
        cursor = conn.cursor()
        
        # Get all wallets
        cursor.execute("SELECT * FROM wallets")
        wallets = cursor.fetchall()
        
        if not wallets:
            print("\nNo wallets found in database!")
            return
        
        print("\n=== Available Wallets ===")
        print("-" * 50)
        
        for wallet in wallets:
            print(f"\nWallet Address: {wallet[0]}")
            print(f"Balance: {wallet[1]} coins")
            print(f"Total Mined: {wallet[2]} coins")
            
            # Parse and display metadata
            try:
                metadata = json.loads(wallet[3])
                print("\nMetadata:")
                for key, value in metadata.items():
                    if key == 'last_mining_session':
                        value = datetime.fromtimestamp(value).strftime('%Y-%m-%d %H:%M:%S')
                    print(f"  {key}: {value}")
            except:
                pass
            print("-" * 30)
        
    except sqlite3.Error as e:
        print(f"Database error: {e}")
    except Exception as e:
        print(f"Error: {e}")
    finally:
        if conn:
            conn.close()

if __name__ == '__main__':
    view_wallets()