from sqlalchemy import create_engine, Column, Integer, String, Float, JSON, Boolean, BigInteger, LargeBinary
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy.orm import sessionmaker
from config import get_db_url

Base = declarative_base()

class DynamicMemory(Base):
    __tablename__ = 'dynamic_memory'
    
    key = Column(String(128), primary_key=True)  # Task-specific memory key
    cpu_id = Column(Integer, index=True)
    data = Column(LargeBinary, nullable=True)  # Only store when needed
    last_accessed = Column(BigInteger)
    task_id = Column(String(64), index=True)  # For grouping related memory
    context = Column(JSON)  # Store task context and metadata

class RegisterState(Base):
    __tablename__ = 'register_states'
    
    cpu_id = Column(Integer, primary_key=True)
    register_id = Column(Integer, primary_key=True)
    value = Column(BigInteger)
    last_updated = Column(BigInteger)

def init_memory_db():
    """Initialize in-memory SQLite database for CPU memory management"""
    engine = create_engine('sqlite:///:memory:', echo=False)
    Base.metadata.create_all(engine)
    return sessionmaker(bind=engine)()
