import psutil
import time

def get_system_info():
    """Get real system CPU information"""
    cpu_info = {
        'physical_cores': psutil.cpu_count(logical=False),
        'logical_cores': psutil.cpu_count(logical=True),
        'cpu_freq': psutil.cpu_freq(),
        'cpu_percent': psutil.cpu_percent(interval=1, percpu=True)
    }
    return cpu_info

class MiningConfig:
    """Configuration for mining parameters"""
    def __init__(self, total_virtual_cpus: int = 1000, virtual_cores_per_cpu: int = 600000, virtual_threads_per_core: int = 400000, virtual_batch_size: int = 10000, nonce_range: int = 0xFFFFFFFF):
        # Test Parameters
        self.test_duration = 120  # 120 seconds runtime
        self.log_interval = 1.0  # Update stats every second
        self.force_stop_margin = 1.0  # Stop 1 second before deadline
        self.show_live_stats = True  # Show live stats in terminal
        
        # Performance Monitoring
        self.progress_interval = 5.0  # Show progress every 5 seconds
        self.final_summary = True  # Show final summary when done
        
        # Real CPU Configuration
        self.real_cpu_info = get_system_info()
        self.use_real_cpu = False  # Only use virtual CPUs
        self.real_cpu_threads = self.real_cpu_info["logical_cores"]
        self.real_batch_size = 1000000
        
        # Virtual CPU Configuration - Scaled down for testing
        self.use_virtual_cpu = True
        self.total_virtual_cpus = total_virtual_cpus
        self.virtual_batch_size = virtual_batch_size
        self.virtual_cores_per_cpu = virtual_cores_per_cpu
        self.virtual_threads_per_core = virtual_threads_per_core
        self.virtual_hashes_per_batch = 1000  # 1k hashes per batch for testing
        self.parallel_batches = 1000  # 1k parallel batches
        self.cpu_groups = 10  # 10 CPU groups for distribution
        
        # Mining Parameters
        self.difficulty_bits = 0x1f000000  # Adjusted for more reasonable difficulty
        self.nonce_start = 0
        self.nonce_range = nonce_range
        
        # Resource Management
        self.max_cpu_usage = 90  # Maximum CPU usage percentage
        self.max_memory_usage = 80  # Maximum memory usage percentage
        self.throttle_sleep = 0.001  # Sleep time when throttling (seconds)

