"""
Shared counters for mining statistics
"""
import multiprocessing as mp
import time

class MiningStats:
    def __init__(self):
        self.total_hashes = mp.RawValue('d', 0)  # Double for large numbers
        self.blocks_found = mp.RawValue('i', 0)  # Integer for block count
        self.start_time = time.time()
        self.lock = mp.Lock()

    def increment_hashes(self, count):
        with self.lock:
            self.total_hashes.value += count
            if self.total_hashes.value % 1000 == 0:  # Log every 1000 hashes
                print(f"\nTotal hashes completed: {self.total_hashes.value:,}")

    def increment_blocks(self):
        with self.lock:
            self.blocks_found.value += 1
            print(f"\nBLOCK FOUND! Total blocks: {self.blocks_found.value}")

    def get_stats(self):
        duration = time.time() - self.start_time
        return {
            'total_hashes': self.total_hashes.value,
            'blocks_found': self.blocks_found.value,
            'duration': duration,
            'hashrate': self.total_hashes.value / duration if duration > 0 else 0
        }

