#!/usr/bin/env python3

import time
from src.core.unified_mining_controller import UnifiedMiningController

def monitor_mining_performance():
    controller = UnifiedMiningController()
    
    print("Starting Mining Performance Monitor...")
    print("Press Ctrl+C to stop monitoring")
    
    try:
        while True:
            stats = controller.get_mining_stats()
            
            # Clear screen
            print("\033[2J\033[H")
            
            # Print overall stats
            print("=== Mining Performance Monitor ===")
            print(f"Total Hashrate: {stats['total_hash_rate']/1e6:.2f} MH/s")
            print(f"CPU Hashrate:   {stats['cpu_hash_rate']/1e6:.2f} MH/s")
            print(f"GPU Hashrate:   {stats['gpu_hash_rate']/1e6:.2f} MH/s")
            print(f"Blocks Found:   {stats['blocks_found']}")
            
            # Print GPU details
            print("\n=== GPU Details ===")
            for gpu, details in stats['gpu_details'].items():
                utilization = details.get("utilization", "N/A")
                temperature = details.get("temperature", "N/A")
                power = details.get("power_usage", "N/A")
                print(f"GPU {gpu}:")
                print(f"  Hashrate:    {details['hash_rate']/1e6:.2f} MH/s")
                print(f"  Utilization: {utilization}%")
                print(f"  Temperature: {temperature}°C")
                print(f"  Power Usage: {power}W")
            
            # Print CPU details
            print("\n=== CPU Grid Status ===")
            cpu_stats = stats['cpu_details']
            print(f"Active Threads:  {cpu_stats.get('active_threads', 'N/A')}")
            print(f"Thread Efficiency: {cpu_stats.get('thread_efficiency', 'N/A')}%")
            
            time.sleep(5)  # Update every 5 seconds
            
    except KeyboardInterrupt:
        print("\nStopping monitor...")

if __name__ == "__main__":
    monitor_mining_performance()
