"""
Example shaders for the advanced virtual GPU shader system.
"""
# Vertex shader (Python demo)
vertex_shader_source = """
def main(vertex):
    # Simple pass-through
    return vertex
"""

# Fragment shader (Python demo)
fragment_shader_source = """
def main(color):
    # Invert color
    return 1.0 - color
"""

# Geometry shader (Python demo)
geometry_shader_source = """
def main(vertices):
    # For demo: just return input
    return vertices
"""

# Compute shader (Python demo)
compute_shader_source = """
def main(data):
    # For demo: double all values
    return [x*2 for x in data]
"""
