"""
Simplified block structure without traditional Bitcoin constraints
"""
import time
import hashlib
from typing import Dict, Any

class SimplifiedBlock:
    def __init__(self):
        self.version = 2
        self.prev_block_hash = ""
        self.timestamp = int(time.time())
        self.nonce = 0
        self.miner_address = ""
        
    def get_header(self) -> bytes:
        """Get block header for mining"""
        header = (
            str(self.version).encode() +
            self.prev_block_hash.encode() +
            str(self.timestamp).encode() +
            str(self.nonce).encode() +
            self.miner_address.encode()
        )
        return header
        
    def compute_hash(self) -> str:
        """Compute block hash"""
        header = self.get_header()
        return hashlib.sha256(header).hexdigest()
        
    def to_dict(self) -> Dict[str, Any]:
        """Convert block to dictionary"""
        return {
            'version': self.version,
            'prev_block_hash': self.prev_block_hash,
            'timestamp': self.timestamp,
            'nonce': self.nonce,
            'miner_address': self.miner_address,
            'hash': self.compute_hash()
        }
