"""
Graphics state enums that are not database-backed
"""
from enum import Enum

class CullMode(Enum):
    NONE = "NONE"
    FRONT = "FRONT"
    BACK = "BACK"
    FRONT_AND_BACK = "FRONT_AND_BACK"

class FrontFace(Enum):
    CW = "CW"
    CCW = "CCW"

class CompareOp(Enum):
    NEVER = "NEVER"
    LESS = "LESS"
    EQUAL = "EQUAL"
    LESS_EQUAL = "LEQUAL"
    GREATER = "GREATER"
    NOT_EQUAL = "NOTEQUAL"
    GREATER_EQUAL = "GEQUAL"
    ALWAYS = "ALWAYS"

class StencilOp(Enum):
    KEEP = "KEEP"
    ZERO = "ZERO"
    REPLACE = "REPLACE"
    INCREMENT_AND_CLAMP = "INCREMENT_AND_CLAMP"
    DECREMENT_AND_CLAMP = "DECREMENT_AND_CLAMP"
    INVERT = "INVERT"
    INCREMENT_AND_WRAP = "INCREMENT_AND_WRAP"
    DECREMENT_AND_WRAP = "DECREMENT_AND_WRAP"

class BlendFactor(Enum):
    ZERO = "ZERO"
    ONE = "ONE"
    SRC_COLOR = "SRC_COLOR"
    ONE_MINUS_SRC_COLOR = "ONE_MINUS_SRC_COLOR"
    DST_COLOR = "DST_COLOR"
    ONE_MINUS_DST_COLOR = "ONE_MINUS_DST_COLOR"
    SRC_ALPHA = "SRC_ALPHA"
    ONE_MINUS_SRC_ALPHA = "ONE_MINUS_SRC_ALPHA"
    DST_ALPHA = "DST_ALPHA"
    ONE_MINUS_DST_ALPHA = "ONE_MINUS_DST_ALPHA"
    CONSTANT_COLOR = "CONSTANT_COLOR"
    ONE_MINUS_CONSTANT_COLOR = "ONE_MINUS_CONSTANT_COLOR"
    CONSTANT_ALPHA = "CONSTANT_ALPHA"
    ONE_MINUS_CONSTANT_ALPHA = "ONE_MINUS_CONSTANT_ALPHA"

class BlendOp(Enum):
    ADD = "ADD"
    SUBTRACT = "SUBTRACT"
    REVERSE_SUBTRACT = "REVERSE_SUBTRACT"
    MIN = "MIN"
    MAX = "MAX"
