"""
virtual_gpu_driver/src/sync.py
Synchronization primitives: barriers, events, atomics for parallel tasks.
"""
import threading

class Barrier:
    def __init__(self, parties):
        self.barrier = threading.Barrier(parties)
    def wait(self):
        self.barrier.wait()

class Event:
    def __init__(self):
        self.event = threading.Event()
    def set(self):
        self.event.set()
    def wait(self, timeout=None):
        self.event.wait(timeout)
    def clear(self):
        self.event.clear()

class AtomicInt:
    def __init__(self, value=0):
        self.value = value
        self.lock = threading.Lock()
    def add(self, delta):
        with self.lock:
            self.value += delta
            return self.value
    def compare_and_swap(self, expected, new):
        with self.lock:
            if self.value == expected:
                self.value = new
                return True
            return False
    def get(self):
        with self.lock:
            return self.value
