"""
Test the advanced mining implementation with electron speed and flip-flops
"""

from advanced_cpu_core import AdvancedMiningCore
import time
import hashlib
import struct

# Target difficulty (example Bitcoin testnet target)
TARGET_DIFFICULTY = 0x00000000FFFF0000000000000000000000000000000000000000000000000000

def test_mining_performance():
    # Initialize with 16 parallel cores
    miner = AdvancedMiningCore(num_parallel_cores=16)
    
    # Set up initial block header
    version = 2
    prev_block = b'\x00' * 32
    merkle_root = b'\x00' * 32
    timestamp = int(time.time())
    bits = 0x1d00ffff
    
    # Pack initial block header
    miner.block_header = bytearray(
        struct.pack('<I32s32sII',
                   version, prev_block, merkle_root,
                   timestamp, bits)
        + b'\x00' * 4  # Initial nonce
    )
    
    # Run mining test for 60 seconds
    start_time = time.time()
    total_hashes = 0
    
    print("Starting 60-second mining test...")
    print("Using electron-speed clock and flip-flop execution units")
    
    while time.time() - start_time < 60:
        nonce, hash_result = miner.mine_block(TARGET_DIFFICULTY)
        total_hashes += 16 * 8  # parallel_cores * exec_units_per_core
        
        if int.from_bytes(hash_result, 'big') < TARGET_DIFFICULTY:
            print(f"\nBlock found! Nonce: {nonce}")
            print(f"Hash: {hash_result.hex()}")
    
    end_time = time.time()
    duration = end_time - start_time
    
    hash_rate = total_hashes / duration
    
    print(f"\nTest completed in {duration:.2f} seconds")
    print(f"Total hashes: {total_hashes:,}")
    print(f"Hash rate: {hash_rate/1000:.2f} KH/s")
    print(f"Using electron drift velocity: {drift_velocity:.2e} m/s")
    print(f"Transistor switching frequency: {max_switch_freq:.2e} Hz")

if __name__ == "__main__":
    test_mining_performance()