import sqlite3
conn = sqlite3.connect('data/cpu_storage.db')
cursor = conn.cursor()

print('\n=== CPU Configurations ===')
cursor.execute('SELECT COUNT(*) FROM cpu_config')
print(f'Configured CPUs: {cursor.fetchone()[0]:,}')

cursor.execute('''
    SELECT cpu_id, core_count, thread_count, initialized
    FROM cpu_config
    LIMIT 5
''')
print('\nSample CPU Configurations:')
for row in cursor.fetchall():
    print(f'CPU {row[0]}: {row[1]} cores, {row[2]} threads, {"Initialized" if row[3] else "Not initialized"}')

conn.close()