"""
Test the HyperScale GPU mining performance
"""
from multi_gpu_system import HyperScaleGPU

def main():
    print("Initializing HyperScale GPU System...")
    gpu_system = HyperScaleGPU()
    
    specs = gpu_system.get_system_specs()
    
    # Print system specs
    print("\nSystem Specifications:")
    print(f"Total GPUs: {specs['total_gpus']:,}")
    print(f"Total Tensor Cores: {specs['total_tensor_cores']:,}")
    print(f"Total VRAM: {specs['total_vram_gb']:,} GB")
    print(f"Switch Frequency: {specs['switch_frequency_hz']:.2e} Hz")
    
    # Print mining performance
    perf = specs['mining_performance']
    print("\nMining Performance (2-hour window):")
    print(f"Hashrate: {perf['hashrate']:.2e} H/s")
    print(f"Network Share: {perf['network_share']*100:.2f}%")
    print(f"Expected Blocks: {perf['expected_blocks']:.2f}")
    print(f"Expected BTC: {perf['expected_btc']:.2f} BTC")
    print(f"Projected Daily BTC: {perf['btc_per_day']:.2f} BTC")
    
    # Print parallel distribution specs
    print("\nParallel Distribution Configuration:")
    pd = specs['parallel_distribution']
    print(f"Max Concurrent Kernels: {pd['max_concurrent_kernels']}")
    print(f"Load Threshold: {pd['load_threshold']*100}%")
    print(f"Min Chunk Size: {pd['min_chunk_size']}")

if __name__ == "__main__":
    main()
